/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.onlab.util.Accumulator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAccumulator<T>
implements Accumulator<T> {
    private Logger log = LoggerFactory.getLogger(AbstractAccumulator.class);
    private final Timer timer;
    private final int maxItems;
    private final int maxBatchMillis;
    private final int maxIdleMillis;
    private TimerTask idleTask = new ProcessorTask();
    private TimerTask maxTask = new ProcessorTask();
    private List<T> items = Lists.newArrayList();

    protected AbstractAccumulator(Timer timer, int maxItems, int maxBatchMillis, int maxIdleMillis) {
        this.timer = Preconditions.checkNotNull(timer, "Timer cannot be null");
        Preconditions.checkArgument(maxItems > 1, "Maximum number of items must be > 1");
        Preconditions.checkArgument(maxBatchMillis > 0, "Maximum millis must be positive");
        Preconditions.checkArgument(maxIdleMillis > 0, "Maximum idle millis must be positive");
        this.maxItems = maxItems;
        this.maxBatchMillis = maxBatchMillis;
        this.maxIdleMillis = maxIdleMillis;
    }

    @Override
    public synchronized void add(T item) {
        this.idleTask = this.cancelIfActive(this.idleTask);
        this.items.add(Preconditions.checkNotNull(item, "Item cannot be null"));
        if (this.items.size() >= this.maxItems) {
            this.maxTask = this.cancelIfActive(this.maxTask);
            this.schedule(1);
        } else {
            this.idleTask = this.schedule(this.maxIdleMillis);
            if (this.items.size() == 1) {
                this.maxTask = this.schedule(this.maxBatchMillis);
            }
        }
    }

    private TimerTask schedule(int millis) {
        ProcessorTask task = new ProcessorTask();
        this.timer.schedule((TimerTask)task, millis);
        return task;
    }

    private TimerTask cancelIfActive(TimerTask task) {
        if (task != null) {
            task.cancel();
        }
        return task;
    }

    private synchronized List<T> finalizeCurrentBatch() {
        List<T> toBeProcessed = this.items;
        this.items = Lists.newArrayList();
        return toBeProcessed;
    }

    @Override
    public boolean isReady() {
        return true;
    }

    public Timer timer() {
        return this.timer;
    }

    public int maxItems() {
        return this.maxItems;
    }

    public int maxBatchMillis() {
        return this.maxBatchMillis;
    }

    public int maxIdleMillis() {
        return this.maxIdleMillis;
    }

    private class ProcessorTask
    extends TimerTask {
        private ProcessorTask() {
        }

        @Override
        public void run() {
            AbstractAccumulator.this.idleTask = AbstractAccumulator.this.cancelIfActive(AbstractAccumulator.this.idleTask);
            if (AbstractAccumulator.this.isReady()) {
                try {
                    AbstractAccumulator.this.maxTask = AbstractAccumulator.this.cancelIfActive(AbstractAccumulator.this.maxTask);
                    AbstractAccumulator.this.processItems(AbstractAccumulator.this.finalizeCurrentBatch());
                }
                catch (Exception e) {
                    AbstractAccumulator.this.log.warn("Unable to process batch due to {}", (Throwable)e);
                }
            } else {
                AbstractAccumulator.this.idleTask = AbstractAccumulator.this.schedule(AbstractAccumulator.this.maxIdleMillis);
            }
        }
    }
}

