/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.onlab.util.BlockingBoolean;
import org.onlab.util.Counter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BoundedThreadPool
extends ThreadPoolExecutor {
    private static final Logger log = LoggerFactory.getLogger(BoundedThreadPool.class);
    protected static int maxQueueSize = 80000;
    private static final long STATS_INTERVAL = 5000L;
    private final BlockingBoolean underHighLoad;
    private final Counter submitted = new Counter();
    private final Counter taken = new Counter();
    private final AtomicLong lastPrinted = new AtomicLong(0L);

    private BoundedThreadPool(int numberOfThreads, ThreadFactory threadFactory) {
        super(numberOfThreads, numberOfThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(maxQueueSize), threadFactory, new CallerFeedbackPolicy());
        this.underHighLoad = ((CallerFeedbackPolicy)this.getRejectedExecutionHandler()).load();
    }

    public static BoundedThreadPool newSingleThreadExecutor(ThreadFactory threadFactory) {
        return new BoundedThreadPool(1, threadFactory);
    }

    public static BoundedThreadPool newFixedThreadPool(int numberOfThreads, ThreadFactory threadFactory) {
        return new BoundedThreadPool(numberOfThreads, threadFactory);
    }

    @Override
    public Future<?> submit(Runnable task) {
        this.submitted.add(1L);
        return super.submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        this.submitted.add(1L);
        return super.submit(task, result);
    }

    @Override
    public void execute(Runnable command) {
        this.submitted.add(1L);
        super.execute(command);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        this.submitted.add(1L);
        return super.submit(task);
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        this.taken.add(1L);
        this.periodicallyPrintStats();
        this.updateLoad();
    }

    private void periodicallyPrintStats() {
        long prev;
        long now = System.currentTimeMillis();
        if (now - (prev = this.lastPrinted.get()) > 5000L && this.lastPrinted.compareAndSet(prev, now)) {
            log.warn("queue size: {} jobs, submitted: {} jobs/s, taken: {} jobs/s", new Object[]{this.getQueue().size(), this.submitted.throughput(), this.taken.throughput()});
            this.submitted.reset();
            this.taken.reset();
        }
    }

    private void updateLoad() {
        this.underHighLoad.set((double)this.getQueue().remainingCapacity() / (double)maxQueueSize < 0.2);
    }

    private static final class CallerFeedbackPolicy
    implements RejectedExecutionHandler {
        private final BlockingBoolean underLoad = new BlockingBoolean(false);

        private CallerFeedbackPolicy() {
        }

        public BlockingBoolean load() {
            return this.underLoad;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            if (!e.isShutdown()) {
                boolean notified = false;
                try {
                    notified = this.underLoad.await(false, 1L, TimeUnit.SECONDS);
                }
                catch (InterruptedException exception) {
                    log.debug("Got exception waiting for notification:", (Throwable)exception);
                }
                finally {
                    if (!notified) {
                        log.info("Waited for 1 second on {}. Proceeding with work...", (Object)Thread.currentThread().getName());
                    } else {
                        log.info("FIXME we got a notice");
                    }
                }
                r.run();
            }
        }
    }
}

