/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class Counter {
    private long total = 0L;
    private long start = System.currentTimeMillis();
    private long end = 0L;

    public Counter() {
    }

    public Counter(long start, long total, long end) {
        Preconditions.checkArgument(start <= end, "Malformed interval: start > end");
        Preconditions.checkArgument(total >= 0L, "Total must be non-negative");
        this.start = start;
        this.total = total;
        this.end = end;
    }

    public synchronized void reset() {
        this.end = 0L;
        this.total = 0L;
        this.start = System.currentTimeMillis();
    }

    public synchronized void freeze() {
        this.end = System.currentTimeMillis();
    }

    public synchronized void add(long count) {
        Preconditions.checkArgument(count >= 0L, "Count must be non-negative");
        if (this.end == 0L) {
            this.total += count;
        }
    }

    public synchronized double throughput() {
        return (double)this.total / this.duration();
    }

    public synchronized long total() {
        return this.total;
    }

    public synchronized double duration() {
        long duration = (this.end == 0L ? System.currentTimeMillis() : this.end) - this.start;
        return (double)(duration == 0L ? 1L : duration) / 1000.0;
    }

    public int hashCode() {
        return Objects.hash(this.total, this.start, this.end);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Counter) {
            Counter other = (Counter)obj;
            return Objects.equals(this.total, other.total) && Objects.equals(this.start, other.start) && Objects.equals(this.end, other.end);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("total", this.total).add("start", this.start).add("end", this.end).toString();
    }
}

