/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cluster;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.onosproject.cluster.NodeId;

public class RoleInfo {
    private final NodeId master;
    private final List<NodeId> backups;

    public RoleInfo(NodeId master, List<NodeId> backups) {
        this.master = master;
        this.backups = ImmutableList.copyOf(backups);
    }

    public RoleInfo() {
        this.master = null;
        this.backups = ImmutableList.of();
    }

    public NodeId master() {
        return this.master;
    }

    public List<NodeId> backups() {
        return this.backups;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof RoleInfo)) {
            return false;
        }
        RoleInfo that = (RoleInfo)other;
        if (!Objects.equals(this.master, that.master)) {
            return false;
        }
        return Objects.equals(this.backups, that.backups);
    }

    public int hashCode() {
        return Objects.hash(this.master, this.backups);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("master", this.master).add("backups", this.backups).toString();
    }
}

