/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.core;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.onosproject.core.Application;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.Permission;
import org.onosproject.core.Version;

public class DefaultApplication
implements Application {
    private final ApplicationId appId;
    private final Version version;
    private final String description;
    private final String origin;
    private final Set<Permission> permissions;
    private final Optional<URI> featuresRepo;
    private final List<String> features;

    public DefaultApplication(ApplicationId appId, Version version, String description, String origin, Set<Permission> permissions, Optional<URI> featuresRepo, List<String> features) {
        this.appId = Preconditions.checkNotNull(appId, "ID cannot be null");
        this.version = Preconditions.checkNotNull(version, "Version cannot be null");
        this.description = Preconditions.checkNotNull(description, "Description cannot be null");
        this.origin = Preconditions.checkNotNull(origin, "Origin cannot be null");
        this.permissions = Preconditions.checkNotNull(permissions, "Permissions cannot be null");
        this.featuresRepo = Preconditions.checkNotNull(featuresRepo, "Features repo cannot be null");
        this.features = Preconditions.checkNotNull(features, "Features cannot be null");
        Preconditions.checkArgument(!features.isEmpty(), "There must be at least one feature");
    }

    @Override
    public ApplicationId id() {
        return this.appId;
    }

    @Override
    public Version version() {
        return this.version;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public String origin() {
        return this.origin;
    }

    @Override
    public Set<Permission> permissions() {
        return this.permissions;
    }

    @Override
    public Optional<URI> featuresRepo() {
        return this.featuresRepo;
    }

    @Override
    public List<String> features() {
        return this.features;
    }

    public int hashCode() {
        return Objects.hash(this.appId, this.version, this.description, this.origin, this.permissions, this.featuresRepo, this.features);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultApplication other = (DefaultApplication)obj;
        return Objects.equals(this.appId, other.appId) && Objects.equals(this.version, other.version) && Objects.equals(this.description, other.description) && Objects.equals(this.origin, other.origin) && Objects.equals(this.permissions, other.permissions) && Objects.equals(this.featuresRepo, other.featuresRepo) && Objects.equals(this.features, other.features);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("appId", this.appId).add("version", this.version).add("description", this.description).add("origin", this.origin).add("permissions", this.permissions).add("featuresRepo", this.featuresRepo).add("features", this.features).toString();
    }
}

