/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.core;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicLong;
import org.onosproject.core.UnavailableIdException;

public final class IdBlock {
    private final long start;
    private final long size;
    private final AtomicLong currentId;

    public IdBlock(long start, long size) {
        Preconditions.checkArgument(size > 0L, "size should be more than 0, but %s", size);
        this.start = start;
        this.size = size;
        this.currentId = new AtomicLong(start);
    }

    private long getStart() {
        return this.start;
    }

    private long getEnd() {
        return this.start + this.size - 1L;
    }

    public long getSize() {
        return this.size;
    }

    public long getNextId() {
        long id = this.currentId.getAndIncrement();
        if (id > this.getEnd()) {
            throw new UnavailableIdException(String.format("used all IDs in allocated space (size: %d, end: %d, current: %d)", this.size, this.getEnd(), id));
        }
        return id;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("start", this.start).add("size", this.size).add("currentId", this.currentId).toString();
    }
}

