/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.event;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.onosproject.event.Event;
import org.onosproject.event.EventSink;
import org.onosproject.event.EventSinkRegistry;

public class DefaultEventSinkRegistry
implements EventSinkRegistry {
    private final Map<Class<? extends Event>, EventSink<? extends Event>> sinks = new ConcurrentHashMap<Class<? extends Event>, EventSink<? extends Event>>();

    @Override
    public <E extends Event> void addSink(Class<E> eventClass, EventSink<E> sink) {
        Preconditions.checkNotNull(eventClass, "Event class cannot be null");
        Preconditions.checkNotNull(sink, "Event sink cannot be null");
        Preconditions.checkArgument(!this.sinks.containsKey(eventClass), "Event sink already registered for %s", eventClass.getName());
        this.sinks.put(eventClass, sink);
    }

    @Override
    public <E extends Event> void removeSink(Class<E> eventClass) {
        Preconditions.checkNotNull(eventClass, "Event class cannot be null");
        Preconditions.checkArgument(this.sinks.remove(eventClass) != null, "Event sink not registered for %s", eventClass.getName());
    }

    @Override
    public <E extends Event> EventSink<E> getSink(Class<E> eventClass) {
        return this.sinks.get(eventClass);
    }

    @Override
    public Set<Class<? extends Event>> getSinks() {
        return ImmutableSet.copyOf(this.sinks.keySet());
    }
}

