/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onosproject.net.AbstractModel;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Link;
import org.onosproject.net.provider.ProviderId;

public class DefaultLink
extends AbstractModel
implements Link {
    private final ConnectPoint src;
    private final ConnectPoint dst;
    private final Link.Type type;
    private final Link.State state;
    private final boolean isDurable;

    public DefaultLink(ProviderId providerId, ConnectPoint src, ConnectPoint dst, Link.Type type, Annotations ... annotations) {
        this(providerId, src, dst, type, Link.State.ACTIVE, false, annotations);
    }

    public DefaultLink(ProviderId providerId, ConnectPoint src, ConnectPoint dst, Link.Type type, Link.State state, boolean isDurable, Annotations ... annotations) {
        super(providerId, annotations);
        this.src = src;
        this.dst = dst;
        this.type = type;
        this.state = state;
        this.isDurable = isDurable;
    }

    @Override
    public ConnectPoint src() {
        return this.src;
    }

    @Override
    public ConnectPoint dst() {
        return this.dst;
    }

    @Override
    public Link.Type type() {
        return this.type;
    }

    @Override
    public Link.State state() {
        return this.state;
    }

    @Override
    public boolean isDurable() {
        return this.isDurable;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.src, this.dst, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultLink) {
            DefaultLink other = (DefaultLink)obj;
            return Objects.equals(this.src, other.src) && Objects.equals(this.dst, other.dst) && Objects.equals((Object)this.type, (Object)other.type);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("src", this.src).add("dst", this.dst).add("type", (Object)this.type).add("state", (Object)this.state).add("durable", this.isDurable).toString();
    }
}

