/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.Link;
import org.onosproject.net.Path;
import org.onosproject.net.provider.ProviderId;

public class DefaultPath
extends DefaultLink
implements Path {
    private final List<Link> links;
    private final double cost;

    public DefaultPath(ProviderId providerId, List<Link> links, double cost, Annotations ... annotations) {
        super(providerId, DefaultPath.source(links), DefaultPath.destination(links), Link.Type.INDIRECT, annotations);
        this.links = ImmutableList.copyOf(links);
        this.cost = cost;
    }

    @Override
    public List<Link> links() {
        return this.links;
    }

    @Override
    public double cost() {
        return this.cost;
    }

    private static ConnectPoint source(List<Link> links) {
        Preconditions.checkNotNull(links, "List of path links cannot be null");
        Preconditions.checkArgument(!links.isEmpty(), "List of path links cannot be empty");
        return links.get(0).src();
    }

    private static ConnectPoint destination(List<Link> links) {
        Preconditions.checkNotNull(links, "List of path links cannot be null");
        Preconditions.checkArgument(!links.isEmpty(), "List of path links cannot be empty");
        return links.get(links.size() - 1).dst();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.links);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultPath) {
            DefaultPath other = (DefaultPath)obj;
            return Objects.equals(this.links, other.links);
        }
        return false;
    }
}

