/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net;

import com.google.common.primitives.UnsignedLongs;
import java.util.Objects;

public final class PortNumber {
    public static final PortNumber P0 = PortNumber.portNumber(0L);
    private static final long MAX_NUMBER = 0xFFFFFFFFL;
    static final long IN_PORT_NUMBER = -8L;
    static final long TABLE_NUMBER = -7L;
    static final long NORMAL_NUMBER = -6L;
    static final long FLOOD_NUMBER = -5L;
    static final long ALL_NUMBER = -4L;
    static final long LOCAL_NUMBER = -2L;
    static final long CONTROLLER_NUMBER = -3L;
    public static final PortNumber IN_PORT = new PortNumber(-8L);
    public static final PortNumber TABLE = new PortNumber(-7L);
    public static final PortNumber NORMAL = new PortNumber(-6L);
    public static final PortNumber FLOOD = new PortNumber(-5L);
    public static final PortNumber ALL = new PortNumber(-4L);
    public static final PortNumber LOCAL = new PortNumber(-2L);
    public static final PortNumber CONTROLLER = new PortNumber(-3L);
    private final long number;

    private PortNumber(long number) {
        this.number = number;
    }

    public static PortNumber portNumber(long number) {
        return new PortNumber(number);
    }

    public static PortNumber portNumber(String string) {
        return new PortNumber(UnsignedLongs.decode(string));
    }

    public boolean isLogical() {
        return this.number < 0L || this.number > 0xFFFFFFFFL;
    }

    public long toLong() {
        return this.number;
    }

    private String decodeLogicalPort() {
        if (this.number == -3L) {
            return "CONTROLLER";
        }
        if (this.number == -2L) {
            return "LOCAL";
        }
        if (this.number == -4L) {
            return "ALL";
        }
        if (this.number == -5L) {
            return "FLOOD";
        }
        if (this.number == -6L) {
            return "NORMAL";
        }
        if (this.number == -7L) {
            return "TABLE";
        }
        if (this.number == -8L) {
            return "IN_PORT";
        }
        return "UNKNOWN";
    }

    public String toString() {
        if (!this.isLogical()) {
            return UnsignedLongs.toString(this.number);
        }
        return this.decodeLogicalPort();
    }

    public int hashCode() {
        return Objects.hash(this.number);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PortNumber) {
            PortNumber other = (PortNumber)obj;
            return this.number == other.number;
        }
        return false;
    }
}

