/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.device;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.net.URI;
import org.onlab.packet.ChassisId;
import org.onosproject.net.AbstractDescription;
import org.onosproject.net.Device;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DeviceDescription;

public class DefaultDeviceDescription
extends AbstractDescription
implements DeviceDescription {
    private final URI uri;
    private final Device.Type type;
    private final String manufacturer;
    private final String hwVersion;
    private final String swVersion;
    private final String serialNumber;
    private final ChassisId chassisId;

    public DefaultDeviceDescription(URI uri, Device.Type type, String manufacturer, String hwVersion, String swVersion, String serialNumber, ChassisId chassis, SparseAnnotations ... annotations) {
        super(annotations);
        this.uri = Preconditions.checkNotNull(uri, "Device URI cannot be null");
        this.type = Preconditions.checkNotNull(type, "Device type cannot be null");
        this.manufacturer = manufacturer;
        this.hwVersion = hwVersion;
        this.swVersion = swVersion;
        this.serialNumber = serialNumber;
        this.chassisId = chassis;
    }

    public DefaultDeviceDescription(DeviceDescription base, SparseAnnotations ... annotations) {
        this(base.deviceURI(), base.type(), base.manufacturer(), base.hwVersion(), base.swVersion(), base.serialNumber(), base.chassisId(), annotations);
    }

    @Override
    public URI deviceURI() {
        return this.uri;
    }

    @Override
    public Device.Type type() {
        return this.type;
    }

    @Override
    public String manufacturer() {
        return this.manufacturer;
    }

    @Override
    public String hwVersion() {
        return this.hwVersion;
    }

    @Override
    public String swVersion() {
        return this.swVersion;
    }

    @Override
    public String serialNumber() {
        return this.serialNumber;
    }

    @Override
    public ChassisId chassisId() {
        return this.chassisId;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("uri", this.uri).add("type", (Object)this.type).add("mfr", this.manufacturer).add("hw", this.hwVersion).add("sw", this.swVersion).add("serial", this.serialNumber).toString();
    }

    private DefaultDeviceDescription() {
        this.uri = null;
        this.type = null;
        this.manufacturer = null;
        this.hwVersion = null;
        this.swVersion = null;
        this.serialNumber = null;
        this.chassisId = null;
    }
}

