/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.device;

import com.google.common.base.MoreObjects;
import org.onosproject.net.AbstractDescription;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.PortDescription;

public class DefaultPortDescription
extends AbstractDescription
implements PortDescription {
    private static final long DEFAULT_SPEED = 1000L;
    private final PortNumber number;
    private final boolean isEnabled;
    private final Port.Type type;
    private final long portSpeed;

    public DefaultPortDescription(PortNumber number, boolean isEnabled, SparseAnnotations ... annotations) {
        this(number, isEnabled, Port.Type.COPPER, 1000L, annotations);
    }

    public DefaultPortDescription(PortNumber number, boolean isEnabled, Port.Type type, long portSpeed, SparseAnnotations ... annotations) {
        super(annotations);
        this.number = number;
        this.isEnabled = isEnabled;
        this.type = type;
        this.portSpeed = portSpeed;
    }

    private DefaultPortDescription() {
        this.number = null;
        this.isEnabled = false;
        this.portSpeed = 1000L;
        this.type = Port.Type.COPPER;
    }

    public DefaultPortDescription(PortDescription base, SparseAnnotations annotations) {
        this(base.portNumber(), base.isEnabled(), base.type(), base.portSpeed(), annotations);
    }

    @Override
    public PortNumber portNumber() {
        return this.number;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public Port.Type type() {
        return this.type;
    }

    @Override
    public long portSpeed() {
        return this.portSpeed;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("number", this.number).add("isEnabled", this.isEnabled).add("type", (Object)this.type).add("portSpeed", this.portSpeed).add("annotations", this.annotations()).toString();
    }
}

