/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.driver;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Set;
import org.onosproject.net.driver.Behaviour;
import org.onosproject.net.driver.Driver;
import org.onosproject.net.driver.DriverData;
import org.onosproject.net.driver.HandlerBehaviour;

public class DefaultDriver
implements Driver {
    private final String name;
    private final String manufacturer;
    private final String hwVersion;
    private final String swVersion;
    private final Map<Class<? extends Behaviour>, Class<? extends Behaviour>> behaviours;
    private final Map<String, String> properties;

    public DefaultDriver(String name, String manufacturer, String hwVersion, String swVersion, Map<Class<? extends Behaviour>, Class<? extends Behaviour>> behaviours, Map<String, String> properties) {
        this.name = Preconditions.checkNotNull(name, "Name cannot be null");
        this.manufacturer = Preconditions.checkNotNull(manufacturer, "Manufacturer cannot be null");
        this.hwVersion = Preconditions.checkNotNull(hwVersion, "HW version cannot be null");
        this.swVersion = Preconditions.checkNotNull(swVersion, "SW version cannot be null");
        this.behaviours = ImmutableMap.copyOf(Preconditions.checkNotNull(behaviours, "Behaviours cannot be null"));
        this.properties = ImmutableMap.copyOf(Preconditions.checkNotNull(properties, "Properties cannot be null"));
    }

    DefaultDriver merge(DefaultDriver other) {
        ImmutableMap.Builder<Class<? extends Behaviour>, Class<? extends Behaviour>> behaviours = ImmutableMap.builder();
        behaviours.putAll(other.behaviours).putAll(this.behaviours);
        ImmutableMap.Builder<String, String> properties = ImmutableMap.builder();
        properties.putAll(other.properties).putAll(this.properties);
        return new DefaultDriver(this.name, this.manufacturer, this.hwVersion, this.swVersion, behaviours.build(), properties.build());
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String manufacturer() {
        return this.manufacturer;
    }

    @Override
    public String hwVersion() {
        return this.hwVersion;
    }

    @Override
    public String swVersion() {
        return this.swVersion;
    }

    @Override
    public Set<Class<? extends Behaviour>> behaviours() {
        return this.behaviours.keySet();
    }

    @Override
    public boolean hasBehaviour(Class<? extends Behaviour> behaviourClass) {
        return this.behaviours.containsKey(behaviourClass);
    }

    @Override
    public <T extends Behaviour> T createBehaviour(DriverData data, Class<T> behaviourClass, boolean handler) {
        Preconditions.checkArgument(handler || !HandlerBehaviour.class.isAssignableFrom(behaviourClass), "{} is applicable only to handler context", behaviourClass.getName());
        Class<? extends Behaviour> implementation = this.behaviours.get(behaviourClass);
        Preconditions.checkArgument(implementation != null, "{} not supported", behaviourClass.getName());
        T behaviour = this.createBehaviour(behaviourClass, implementation);
        behaviour.setData(data);
        return behaviour;
    }

    private <T extends Behaviour> T createBehaviour(Class<T> behaviourClass, Class<? extends Behaviour> implementation) {
        try {
            return (T)implementation.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("Unable to create behaviour", e);
        }
    }

    @Override
    public Set<String> keys() {
        return this.properties.keySet();
    }

    @Override
    public String value(String key) {
        return this.properties.get(key);
    }

    @Override
    public Map<String, String> properties() {
        return this.properties;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).add("manufacturer", this.manufacturer).add("hwVersion", this.hwVersion).add("swVersion", this.swVersion).add("behaviours", this.behaviours).add("properties", this.properties).toString();
    }
}

