/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.driver;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.onosproject.net.MutableAnnotations;
import org.onosproject.net.driver.Behaviour;
import org.onosproject.net.driver.Driver;
import org.onosproject.net.driver.DriverData;

public class DefaultDriverData
implements DriverData {
    private final Driver type;
    private final Map<String, String> properties;

    public DefaultDriverData(Driver type) {
        this.type = type;
        this.properties = new HashMap<String, String>();
    }

    @Override
    public Driver type() {
        return this.type;
    }

    @Override
    public <T extends Behaviour> T behaviour(Class<T> behaviourClass) {
        return this.type.createBehaviour(this, behaviourClass, false);
    }

    @Override
    public MutableAnnotations set(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    @Override
    public MutableAnnotations clear(String ... keys) {
        if (keys.length == 0) {
            this.properties.clear();
        } else {
            for (String key : keys) {
                this.properties.remove(key);
            }
        }
        return this;
    }

    @Override
    public Set<String> keys() {
        return ImmutableSet.copyOf(this.properties.keySet());
    }

    @Override
    public String value(String key) {
        return this.properties.get(key);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("type", this.type).add("properties", this.properties).toString();
    }
}

