/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.driver;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.onosproject.net.driver.DefaultDriver;
import org.onosproject.net.driver.Driver;
import org.onosproject.net.driver.DriverProvider;

public class DefaultDriverProvider
implements DriverProvider {
    private final Map<String, DefaultDriver> drivers = new HashMap<String, DefaultDriver>();

    @Override
    public Set<Driver> getDrivers() {
        return ImmutableSet.copyOf(this.drivers.values());
    }

    public void addDrivers(Set<DefaultDriver> driverClasses) {
        for (DefaultDriver driverClass : driverClasses) {
            this.addDriver(driverClass);
        }
    }

    public void addDriver(DefaultDriver driverClass) {
        DefaultDriver ddc = this.drivers.get(driverClass.name());
        if (ddc == null) {
            this.drivers.put(driverClass.name(), driverClass);
        } else {
            this.drivers.put(driverClass.name(), ddc.merge(driverClass));
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("drivers", this.drivers).toString();
    }
}

