/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.driver;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.onosproject.net.driver.Behaviour;
import org.onosproject.net.driver.DefaultDriver;
import org.onosproject.net.driver.DefaultDriverProvider;

public class XmlDriverLoader {
    private static final String DRIVERS = "drivers";
    private static final String DRIVER = "driver";
    private static final String BEHAVIOUR = "behaviour";
    private static final String PROPERTY = "property";
    private static final String NAME = "[@name]";
    private static final String MFG = "[@manufacturer]";
    private static final String HW = "[@hwVersion]";
    private static final String SW = "[@swVersion]";
    private static final String API = "[@api]";
    private static final String IMPL = "[@impl]";
    private final ClassLoader classLoader;

    public XmlDriverLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public DefaultDriverProvider loadDrivers(InputStream driversStream) throws IOException {
        try {
            XMLConfiguration cfg = new XMLConfiguration();
            cfg.setRootElementName(DRIVERS);
            cfg.setAttributeSplittingDisabled(true);
            cfg.load(driversStream);
            return this.loadDrivers(cfg);
        }
        catch (ConfigurationException e) {
            throw new IOException("Unable to load drivers", e);
        }
    }

    public DefaultDriverProvider loadDrivers(HierarchicalConfiguration driversCfg) {
        DefaultDriverProvider provider = new DefaultDriverProvider();
        for (HierarchicalConfiguration cfg : driversCfg.configurationsAt(DRIVER)) {
            provider.addDriver(this.loadDriver(cfg));
        }
        return provider;
    }

    public DefaultDriver loadDriver(HierarchicalConfiguration driverCfg) {
        String name = driverCfg.getString(NAME);
        String manufacturer = driverCfg.getString(MFG, "");
        String hwVersion = driverCfg.getString(HW, "");
        String swVersion = driverCfg.getString(SW, "");
        return new DefaultDriver(name, manufacturer, hwVersion, swVersion, this.parseBehaviours(driverCfg), this.parseProperties(driverCfg));
    }

    private Map<Class<? extends Behaviour>, Class<? extends Behaviour>> parseBehaviours(HierarchicalConfiguration driverCfg) {
        ImmutableMap.Builder<Class<? extends Behaviour>, Class<? extends Behaviour>> behaviours = ImmutableMap.builder();
        for (HierarchicalConfiguration b : driverCfg.configurationsAt(BEHAVIOUR)) {
            behaviours.put(this.getClass(b.getString(API)), this.getClass(b.getString(IMPL)));
        }
        return behaviours.build();
    }

    private Map<String, String> parseProperties(HierarchicalConfiguration driverCfg) {
        ImmutableMap.Builder<String, String> properties = ImmutableMap.builder();
        for (HierarchicalConfiguration b : driverCfg.configurationsAt(PROPERTY)) {
            properties.put(b.getString(NAME), (String)b.getRootNode().getValue());
        }
        return properties.build();
    }

    private Class<? extends Behaviour> getClass(String className) {
        try {
            return this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Unable to load class " + className, e);
        }
    }
}

