/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class BatchOperationEntry<T extends Enum<?>, U> {
    private final T operator;
    private final U target;

    public BatchOperationEntry(T operator, U target) {
        this.operator = (Enum)Preconditions.checkNotNull(operator);
        this.target = Preconditions.checkNotNull(target);
    }

    public U target() {
        return this.target;
    }

    public T operator() {
        return this.operator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchOperationEntry other = (BatchOperationEntry)o;
        return this.operator == other.operator && Objects.equals(this.target, other.target);
    }

    public int hashCode() {
        return Objects.hash(this.operator, this.target);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("operator", this.operator).add("target", this.target).toString();
    }
}

