/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Set;
import org.onosproject.net.DeviceId;
import org.onosproject.net.flow.BatchOperationResult;
import org.onosproject.net.flow.FlowRule;

public class CompletedBatchOperation
implements BatchOperationResult<FlowRule> {
    private final boolean success;
    private final Set<FlowRule> failures;
    private final Set<Long> failedIds;
    private final DeviceId deviceId;

    public CompletedBatchOperation(boolean success, Set<? extends FlowRule> failures, Set<Long> failedIds, DeviceId deviceId) {
        this.success = success;
        this.failures = ImmutableSet.copyOf(failures);
        this.failedIds = ImmutableSet.copyOf(failedIds);
        this.deviceId = deviceId;
    }

    public CompletedBatchOperation(boolean success, Set<? extends FlowRule> failures, DeviceId deviceId) {
        this.success = success;
        this.failures = ImmutableSet.copyOf(failures);
        this.failedIds = Collections.emptySet();
        this.deviceId = deviceId;
    }

    @Override
    public boolean isSuccess() {
        return this.success;
    }

    @Override
    public Set<FlowRule> failedItems() {
        return this.failures;
    }

    public Set<Long> failedIds() {
        return this.failedIds;
    }

    public DeviceId deviceId() {
        return this.deviceId;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("success?", this.success).add("failedItems", this.failures).add("failedIds", this.failedIds).add("deviceId", this.deviceId).toString();
    }
}

