/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.onlab.packet.Ip6Address;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.MplsLabel;
import org.onlab.packet.VlanId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flow.criteria.Criterion;

public final class DefaultTrafficSelector
implements TrafficSelector {
    private final Set<Criterion> criteria;
    private static final TrafficSelector EMPTY = new DefaultTrafficSelector(Collections.emptySet());

    private DefaultTrafficSelector(Set<Criterion> criteria) {
        this.criteria = ImmutableSet.copyOf(criteria);
    }

    @Override
    public Set<Criterion> criteria() {
        return this.criteria;
    }

    @Override
    public Criterion getCriterion(Criterion.Type type) {
        for (Criterion c : this.criteria) {
            if (c.type() != type) continue;
            return c;
        }
        return null;
    }

    public int hashCode() {
        return this.criteria.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultTrafficSelector) {
            DefaultTrafficSelector that = (DefaultTrafficSelector)obj;
            return Objects.equals(this.criteria, that.criteria);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("criteria", this.criteria).toString();
    }

    public static TrafficSelector.Builder builder() {
        return new Builder();
    }

    public static TrafficSelector emptySelector() {
        return EMPTY;
    }

    public static TrafficSelector.Builder builder(TrafficSelector selector) {
        return new Builder(selector);
    }

    public static final class Builder
    implements TrafficSelector.Builder {
        private final Map<Criterion.Type, Criterion> selector = new HashMap<Criterion.Type, Criterion>();

        private Builder() {
        }

        private Builder(TrafficSelector selector) {
            for (Criterion c : selector.criteria()) {
                this.add(c);
            }
        }

        @Override
        public Builder add(Criterion criterion) {
            this.selector.put(criterion.type(), criterion);
            return this;
        }

        @Override
        public Builder matchInPort(PortNumber port) {
            return this.add(Criteria.matchInPort(port));
        }

        @Override
        public Builder matchInPhyPort(PortNumber port) {
            return this.add(Criteria.matchInPhyPort(port));
        }

        @Override
        public Builder matchMetadata(long metadata) {
            return this.add(Criteria.matchMetadata(metadata));
        }

        @Override
        public Builder matchEthDst(MacAddress addr) {
            return this.add(Criteria.matchEthDst(addr));
        }

        @Override
        public Builder matchEthSrc(MacAddress addr) {
            return this.add(Criteria.matchEthSrc(addr));
        }

        @Override
        public Builder matchEthType(short ethType) {
            return this.add(Criteria.matchEthType(ethType));
        }

        @Override
        public Builder matchVlanId(VlanId vlanId) {
            return this.add(Criteria.matchVlanId(vlanId));
        }

        @Override
        public Builder matchVlanPcp(byte vlanPcp) {
            return this.add(Criteria.matchVlanPcp(vlanPcp));
        }

        @Override
        public Builder matchIPDscp(byte ipDscp) {
            return this.add(Criteria.matchIPDscp(ipDscp));
        }

        @Override
        public Builder matchIPEcn(byte ipEcn) {
            return this.add(Criteria.matchIPEcn(ipEcn));
        }

        @Override
        public Builder matchIPProtocol(byte proto) {
            return this.add(Criteria.matchIPProtocol(proto));
        }

        @Override
        public Builder matchIPSrc(IpPrefix ip) {
            return this.add(Criteria.matchIPSrc(ip));
        }

        @Override
        public Builder matchIPDst(IpPrefix ip) {
            return this.add(Criteria.matchIPDst(ip));
        }

        @Override
        public Builder matchTcpSrc(short tcpPort) {
            return this.add(Criteria.matchTcpSrc(tcpPort));
        }

        @Override
        public Builder matchTcpDst(short tcpPort) {
            return this.add(Criteria.matchTcpDst(tcpPort));
        }

        @Override
        public Builder matchUdpSrc(short udpPort) {
            return this.add(Criteria.matchUdpSrc(udpPort));
        }

        @Override
        public Builder matchUdpDst(short udpPort) {
            return this.add(Criteria.matchUdpDst(udpPort));
        }

        @Override
        public Builder matchSctpSrc(short sctpPort) {
            return this.add(Criteria.matchSctpSrc(sctpPort));
        }

        @Override
        public Builder matchSctpDst(short sctpPort) {
            return this.add(Criteria.matchSctpDst(sctpPort));
        }

        @Override
        public Builder matchIcmpType(byte icmpType) {
            return this.add(Criteria.matchIcmpType(icmpType));
        }

        @Override
        public Builder matchIcmpCode(byte icmpCode) {
            return this.add(Criteria.matchIcmpCode(icmpCode));
        }

        @Override
        public Builder matchIPv6Src(IpPrefix ip) {
            return this.add(Criteria.matchIPv6Src(ip));
        }

        @Override
        public Builder matchIPv6Dst(IpPrefix ip) {
            return this.add(Criteria.matchIPv6Dst(ip));
        }

        @Override
        public Builder matchIPv6FlowLabel(int flowLabel) {
            return this.add(Criteria.matchIPv6FlowLabel(flowLabel));
        }

        @Override
        public Builder matchIcmpv6Type(byte icmpv6Type) {
            return this.add(Criteria.matchIcmpv6Type(icmpv6Type));
        }

        @Override
        public Builder matchIcmpv6Code(byte icmpv6Code) {
            return this.add(Criteria.matchIcmpv6Code(icmpv6Code));
        }

        @Override
        public Builder matchIPv6NDTargetAddress(Ip6Address targetAddress) {
            return this.add(Criteria.matchIPv6NDTargetAddress(targetAddress));
        }

        @Override
        public Builder matchIPv6NDSourceLinkLayerAddress(MacAddress mac) {
            return this.add(Criteria.matchIPv6NDSourceLinkLayerAddress(mac));
        }

        @Override
        public Builder matchIPv6NDTargetLinkLayerAddress(MacAddress mac) {
            return this.add(Criteria.matchIPv6NDTargetLinkLayerAddress(mac));
        }

        @Override
        public Builder matchMplsLabel(MplsLabel mplsLabel) {
            return this.add(Criteria.matchMplsLabel(mplsLabel));
        }

        @Override
        public Builder matchIPv6ExthdrFlags(int exthdrFlags) {
            return this.add(Criteria.matchIPv6ExthdrFlags(exthdrFlags));
        }

        @Override
        public Builder matchLambda(short lambda) {
            return this.add(Criteria.matchLambda(lambda));
        }

        @Override
        public Builder matchOpticalSignalType(short signalType) {
            return this.add(Criteria.matchOpticalSignalType(signalType));
        }

        @Override
        public TrafficSelector build() {
            return new DefaultTrafficSelector(ImmutableSet.copyOf(this.selector.values()));
        }
    }
}

