/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow.criteria;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onlab.packet.Ip6Address;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.MplsLabel;
import org.onlab.packet.VlanId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.criteria.Criterion;

public final class Criteria {
    private Criteria() {
    }

    public static Criterion matchInPort(PortNumber port) {
        return new PortCriterion(port, Criterion.Type.IN_PORT);
    }

    public static Criterion matchInPhyPort(PortNumber port) {
        return new PortCriterion(port, Criterion.Type.IN_PHY_PORT);
    }

    public static Criterion matchMetadata(long metadata) {
        return new MetadataCriterion(metadata);
    }

    public static Criterion matchEthDst(MacAddress mac) {
        return new EthCriterion(mac, Criterion.Type.ETH_DST);
    }

    public static Criterion matchEthSrc(MacAddress mac) {
        return new EthCriterion(mac, Criterion.Type.ETH_SRC);
    }

    public static Criterion matchEthType(int ethType) {
        return new EthTypeCriterion(ethType);
    }

    public static Criterion matchVlanId(VlanId vlanId) {
        return new VlanIdCriterion(vlanId);
    }

    public static Criterion matchVlanPcp(byte vlanPcp) {
        return new VlanPcpCriterion(vlanPcp);
    }

    public static Criterion matchIPDscp(byte ipDscp) {
        return new IPDscpCriterion(ipDscp);
    }

    public static Criterion matchIPEcn(byte ipEcn) {
        return new IPEcnCriterion(ipEcn);
    }

    public static Criterion matchIPProtocol(short proto) {
        return new IPProtocolCriterion(proto);
    }

    public static Criterion matchIPSrc(IpPrefix ip) {
        return new IPCriterion(ip, Criterion.Type.IPV4_SRC);
    }

    public static Criterion matchIPDst(IpPrefix ip) {
        return new IPCriterion(ip, Criterion.Type.IPV4_DST);
    }

    public static Criterion matchTcpSrc(int tcpPort) {
        return new TcpPortCriterion(tcpPort, Criterion.Type.TCP_SRC);
    }

    public static Criterion matchTcpDst(int tcpPort) {
        return new TcpPortCriterion(tcpPort, Criterion.Type.TCP_DST);
    }

    public static Criterion matchUdpSrc(int udpPort) {
        return new UdpPortCriterion(udpPort, Criterion.Type.UDP_SRC);
    }

    public static Criterion matchUdpDst(int udpPort) {
        return new UdpPortCriterion(udpPort, Criterion.Type.UDP_DST);
    }

    public static Criterion matchSctpSrc(int sctpPort) {
        return new SctpPortCriterion(sctpPort, Criterion.Type.SCTP_SRC);
    }

    public static Criterion matchSctpDst(int sctpPort) {
        return new SctpPortCriterion(sctpPort, Criterion.Type.SCTP_DST);
    }

    public static Criterion matchIcmpType(short icmpType) {
        return new IcmpTypeCriterion(icmpType);
    }

    public static Criterion matchIcmpCode(short icmpCode) {
        return new IcmpCodeCriterion(icmpCode);
    }

    public static Criterion matchIPv6Src(IpPrefix ip) {
        return new IPCriterion(ip, Criterion.Type.IPV6_SRC);
    }

    public static Criterion matchIPv6Dst(IpPrefix ip) {
        return new IPCriterion(ip, Criterion.Type.IPV6_DST);
    }

    public static Criterion matchIPv6FlowLabel(int flowLabel) {
        return new IPv6FlowLabelCriterion(flowLabel);
    }

    public static Criterion matchIcmpv6Type(short icmpv6Type) {
        return new Icmpv6TypeCriterion(icmpv6Type);
    }

    public static Criterion matchIcmpv6Code(short icmpv6Code) {
        return new Icmpv6CodeCriterion(icmpv6Code);
    }

    public static Criterion matchIPv6NDTargetAddress(Ip6Address targetAddress) {
        return new IPv6NDTargetAddressCriterion(targetAddress);
    }

    public static Criterion matchIPv6NDSourceLinkLayerAddress(MacAddress mac) {
        return new IPv6NDLinkLayerAddressCriterion(mac, Criterion.Type.IPV6_ND_SLL);
    }

    public static Criterion matchIPv6NDTargetLinkLayerAddress(MacAddress mac) {
        return new IPv6NDLinkLayerAddressCriterion(mac, Criterion.Type.IPV6_ND_TLL);
    }

    public static Criterion matchMplsLabel(MplsLabel mplsLabel) {
        return new MplsCriterion(mplsLabel);
    }

    public static Criterion matchIPv6ExthdrFlags(int exthdrFlags) {
        return new IPv6ExthdrFlagsCriterion(exthdrFlags);
    }

    public static Criterion matchLambda(int lambda) {
        return new LambdaCriterion(lambda, Criterion.Type.OCH_SIGID);
    }

    public static Criterion matchOpticalSignalType(short sigType) {
        return new OpticalSignalTypeCriterion(sigType, Criterion.Type.OCH_SIGTYPE);
    }

    public static final class OpticalSignalTypeCriterion
    implements Criterion {
        private static final short MASK = 255;
        private final short signalType;
        private final Criterion.Type type;

        public OpticalSignalTypeCriterion(short signalType, Criterion.Type type) {
            this.signalType = (short)(signalType & 0xFF);
            this.type = type;
        }

        @Override
        public Criterion.Type type() {
            return this.type;
        }

        public short signalType() {
            return this.signalType;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.type().toString()).add("signalType", this.signalType).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.signalType});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof OpticalSignalTypeCriterion) {
                OpticalSignalTypeCriterion that = (OpticalSignalTypeCriterion)obj;
                return Objects.equals(this.signalType, that.signalType) && Objects.equals((Object)this.type, (Object)that.type);
            }
            return false;
        }
    }

    public static final class LambdaCriterion
    implements Criterion {
        private static final int MASK = 65535;
        private final int lambda;
        private final Criterion.Type type;

        public LambdaCriterion(int lambda, Criterion.Type type) {
            this.lambda = lambda & 0xFFFF;
            this.type = type;
        }

        @Override
        public Criterion.Type type() {
            return this.type;
        }

        public int lambda() {
            return this.lambda;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.type().toString()).add("lambda", this.lambda).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.lambda});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof LambdaCriterion) {
                LambdaCriterion that = (LambdaCriterion)obj;
                return Objects.equals(this.lambda, that.lambda) && Objects.equals((Object)this.type, (Object)that.type);
            }
            return false;
        }
    }

    public static final class IPv6ExthdrFlagsCriterion
    implements Criterion {
        private static final int MASK = 65535;
        private final int exthdrFlags;

        public IPv6ExthdrFlagsCriterion(int exthdrFlags) {
            this.exthdrFlags = exthdrFlags & 0xFFFF;
        }

        @Override
        public Criterion.Type type() {
            return Criterion.Type.IPV6_EXTHDR;
        }

        public int exthdrFlags() {
            return this.exthdrFlags;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.type().toString()).add("exthdrFlags", Long.toHexString(this.exthdrFlags)).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.exthdrFlags});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof IPv6ExthdrFlagsCriterion) {
                IPv6ExthdrFlagsCriterion that = (IPv6ExthdrFlagsCriterion)obj;
                return Objects.equals(this.exthdrFlags, that.exthdrFlags) && Objects.equals((Object)this.type(), (Object)that.type());
            }
            return false;
        }
    }

    public static final class MplsCriterion
    implements Criterion {
        private static final int MASK = 1048575;
        private final MplsLabel mplsLabel;

        public MplsCriterion(MplsLabel mplsLabel) {
            this.mplsLabel = mplsLabel;
        }

        @Override
        public Criterion.Type type() {
            return Criterion.Type.MPLS_LABEL;
        }

        public MplsLabel label() {
            return this.mplsLabel;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.type().toString()).add("mpls", this.mplsLabel).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.mplsLabel});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof MplsCriterion) {
                MplsCriterion that = (MplsCriterion)obj;
                return Objects.equals(this.mplsLabel, that.mplsLabel) && Objects.equals((Object)this.type(), (Object)that.type());
            }
            return false;
        }
    }

    public static final class IPv6NDLinkLayerAddressCriterion
    implements Criterion {
        private final MacAddress mac;
        private final Criterion.Type type;

        public IPv6NDLinkLayerAddressCriterion(MacAddress mac, Criterion.Type type) {
            this.mac = mac;
            this.type = type;
        }

        @Override
        public Criterion.Type type() {
            return this.type;
        }

        public MacAddress mac() {
            return this.mac;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.type().toString()).add("mac", this.mac).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.mac});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof IPv6NDLinkLayerAddressCriterion) {
                IPv6NDLinkLayerAddressCriterion that = (IPv6NDLinkLayerAddressCriterion)obj;
                return Objects.equals(this.mac, that.mac) && Objects.equals((Object)this.type, (Object)that.type);
            }
            return false;
        }
    }

    public static final class IPv6NDTargetAddressCriterion
    implements Criterion {
        private final Ip6Address targetAddress;

        public IPv6NDTargetAddressCriterion(Ip6Address targetAddress) {
            this.targetAddress = targetAddress;
        }

        @Override
        public Criterion.Type type() {
            return Criterion.Type.IPV6_ND_TARGET;
        }

        public Ip6Address targetAddress() {
            return this.targetAddress;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.type().toString()).add("targetAddress", this.targetAddress).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.targetAddress});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof IPv6NDTargetAddressCriterion) {
                IPv6NDTargetAddressCriterion that = (IPv6NDTargetAddressCriterion)obj;
                return Objects.equals(this.targetAddress, that.targetAddress) && Objects.equals((Object)this.type(), (Object)that.type());
            }
            return false;
        }
    }

    public static final class Icmpv6CodeCriterion
    implements Criterion {
        private static final short MASK = 255;
        private final short icmpv6Code;

        public Icmpv6CodeCriterion(short icmpv6Code) {
            this.icmpv6Code = (short)(icmpv6Code & 0xFF);
        }

        @Override
        public Criterion.Type type() {
            return Criterion.Type.ICMPV6_CODE;
        }

        public short icmpv6Code() {
            return this.icmpv6Code;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.type().toString()).add("icmpv6Code", this.icmpv6Code).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.icmpv6Code});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Icmpv6CodeCriterion) {
                Icmpv6CodeCriterion that = (Icmpv6CodeCriterion)obj;
                return Objects.equals(this.icmpv6Code, that.icmpv6Code) && Objects.equals((Object)this.type(), (Object)that.type());
            }
            return false;
        }
    }

    public static final class Icmpv6TypeCriterion
    implements Criterion {
        private static final short MASK = 255;
        private final short icmpv6Type;

        public Icmpv6TypeCriterion(short icmpv6Type) {
            this.icmpv6Type = (short)(icmpv6Type & 0xFF);
        }

        @Override
        public Criterion.Type type() {
            return Criterion.Type.ICMPV6_TYPE;
        }

        public short icmpv6Type() {
            return this.icmpv6Type;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.type().toString()).add("icmpv6Type", this.icmpv6Type).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.icmpv6Type});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Icmpv6TypeCriterion) {
                Icmpv6TypeCriterion that = (Icmpv6TypeCriterion)obj;
                return Objects.equals(this.icmpv6Type, that.icmpv6Type) && Objects.equals((Object)this.type(), (Object)that.type());
            }
            return false;
        }
    }

    public static final class IPv6FlowLabelCriterion
    implements Criterion {
        private static final int MASK = 1048575;
        private final int flowLabel;

        public IPv6FlowLabelCriterion(int flowLabel) {
            this.flowLabel = flowLabel & 0xFFFFF;
        }

        @Override
        public Criterion.Type type() {
            return Criterion.Type.IPV6_FLABEL;
        }

        public int flowLabel() {
            return this.flowLabel;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.type().toString()).add("flowLabel", Long.toHexString(this.flowLabel)).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.flowLabel});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof IPv6FlowLabelCriterion) {
                IPv6FlowLabelCriterion that = (IPv6FlowLabelCriterion)obj;
                return Objects.equals(this.flowLabel, that.flowLabel) && Objects.equals((Object)this.type(), (Object)that.type());
            }
            return false;
        }
    }

    public static final class IcmpCodeCriterion
    implements Criterion {
        private static final short MASK = 255;
        private final short icmpCode;

        public IcmpCodeCriterion(short icmpCode) {
            this.icmpCode = (short)(icmpCode & 0xFF);
        }

        @Override
        public Criterion.Type type() {
            return Criterion.Type.ICMPV4_CODE;
        }

        public short icmpCode() {
            return this.icmpCode;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.type().toString()).add("icmpCode", this.icmpCode).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.icmpCode});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof IcmpCodeCriterion) {
                IcmpCodeCriterion that = (IcmpCodeCriterion)obj;
                return Objects.equals(this.icmpCode, that.icmpCode) && Objects.equals((Object)this.type(), (Object)that.type());
            }
            return false;
        }
    }

    public static final class IcmpTypeCriterion
    implements Criterion {
        private static final short MASK = 255;
        private final short icmpType;

        public IcmpTypeCriterion(short icmpType) {
            this.icmpType = (short)(icmpType & 0xFF);
        }

        @Override
        public Criterion.Type type() {
            return Criterion.Type.ICMPV4_TYPE;
        }

        public short icmpType() {
            return this.icmpType;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.type().toString()).add("icmpType", this.icmpType).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.icmpType});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof IcmpTypeCriterion) {
                IcmpTypeCriterion that = (IcmpTypeCriterion)obj;
                return Objects.equals(this.icmpType, that.icmpType) && Objects.equals((Object)this.type(), (Object)that.type());
            }
            return false;
        }
    }

    public static final class SctpPortCriterion
    implements Criterion {
        private static final int MASK = 65535;
        private final int sctpPort;
        private final Criterion.Type type;

        public SctpPortCriterion(int sctpPort, Criterion.Type type) {
            this.sctpPort = sctpPort & 0xFFFF;
            this.type = type;
        }

        @Override
        public Criterion.Type type() {
            return this.type;
        }

        public int sctpPort() {
            return this.sctpPort;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.type().toString()).add("sctpPort", this.sctpPort).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.sctpPort});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof SctpPortCriterion) {
                SctpPortCriterion that = (SctpPortCriterion)obj;
                return Objects.equals(this.sctpPort, that.sctpPort) && Objects.equals((Object)this.type, (Object)that.type);
            }
            return false;
        }
    }

    public static final class UdpPortCriterion
    implements Criterion {
        private static final int MASK = 65535;
        private final int udpPort;
        private final Criterion.Type type;

        public UdpPortCriterion(int udpPort, Criterion.Type type) {
            this.udpPort = udpPort & 0xFFFF;
            this.type = type;
        }

        @Override
        public Criterion.Type type() {
            return this.type;
        }

        public int udpPort() {
            return this.udpPort;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.type().toString()).add("udpPort", this.udpPort).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.udpPort});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof UdpPortCriterion) {
                UdpPortCriterion that = (UdpPortCriterion)obj;
                return Objects.equals(this.udpPort, that.udpPort) && Objects.equals((Object)this.type, (Object)that.type);
            }
            return false;
        }
    }

    public static final class TcpPortCriterion
    implements Criterion {
        private static final int MASK = 65535;
        private final int tcpPort;
        private final Criterion.Type type;

        public TcpPortCriterion(int tcpPort, Criterion.Type type) {
            this.tcpPort = tcpPort & 0xFFFF;
            this.type = type;
        }

        @Override
        public Criterion.Type type() {
            return this.type;
        }

        public int tcpPort() {
            return this.tcpPort;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.type().toString()).add("tcpPort", this.tcpPort).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.tcpPort});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof TcpPortCriterion) {
                TcpPortCriterion that = (TcpPortCriterion)obj;
                return Objects.equals(this.tcpPort, that.tcpPort) && Objects.equals((Object)this.type, (Object)that.type);
            }
            return false;
        }
    }

    public static final class IPCriterion
    implements Criterion {
        private final IpPrefix ip;
        private final Criterion.Type type;

        public IPCriterion(IpPrefix ip, Criterion.Type type) {
            this.ip = ip;
            this.type = type;
        }

        @Override
        public Criterion.Type type() {
            return this.type;
        }

        public IpPrefix ip() {
            return this.ip;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.type().toString()).add("ip", this.ip).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.ip});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof IPCriterion) {
                IPCriterion that = (IPCriterion)obj;
                return Objects.equals(this.ip, that.ip) && Objects.equals((Object)this.type, (Object)that.type);
            }
            return false;
        }
    }

    public static final class IPProtocolCriterion
    implements Criterion {
        private static final short MASK = 255;
        private final short proto;

        public IPProtocolCriterion(short protocol) {
            this.proto = (short)(protocol & 0xFF);
        }

        @Override
        public Criterion.Type type() {
            return Criterion.Type.IP_PROTO;
        }

        public short protocol() {
            return this.proto;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.type().toString()).add("protocol", this.proto).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.proto});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof IPProtocolCriterion) {
                IPProtocolCriterion that = (IPProtocolCriterion)obj;
                return Objects.equals(this.proto, that.proto);
            }
            return false;
        }
    }

    public static final class IPEcnCriterion
    implements Criterion {
        private static final byte MASK = 3;
        private final byte ipEcn;

        public IPEcnCriterion(byte ipEcn) {
            this.ipEcn = (byte)(ipEcn & 3);
        }

        @Override
        public Criterion.Type type() {
            return Criterion.Type.IP_ECN;
        }

        public byte ipEcn() {
            return this.ipEcn;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.type().toString()).add("ipEcn", Long.toHexString(this.ipEcn)).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.ipEcn});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof IPEcnCriterion) {
                IPEcnCriterion that = (IPEcnCriterion)obj;
                return Objects.equals(this.ipEcn, that.ipEcn) && Objects.equals((Object)this.type(), (Object)that.type());
            }
            return false;
        }
    }

    public static final class IPDscpCriterion
    implements Criterion {
        private static final byte MASK = 63;
        private final byte ipDscp;

        public IPDscpCriterion(byte ipDscp) {
            this.ipDscp = (byte)(ipDscp & 0x3F);
        }

        @Override
        public Criterion.Type type() {
            return Criterion.Type.IP_DSCP;
        }

        public byte ipDscp() {
            return this.ipDscp;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.type().toString()).add("ipDscp", Long.toHexString(this.ipDscp)).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.ipDscp});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof IPDscpCriterion) {
                IPDscpCriterion that = (IPDscpCriterion)obj;
                return Objects.equals(this.ipDscp, that.ipDscp) && Objects.equals((Object)this.type(), (Object)that.type());
            }
            return false;
        }
    }

    public static final class VlanPcpCriterion
    implements Criterion {
        private static final byte MASK = 7;
        private final byte vlanPcp;

        public VlanPcpCriterion(byte vlanPcp) {
            this.vlanPcp = (byte)(vlanPcp & 7);
        }

        @Override
        public Criterion.Type type() {
            return Criterion.Type.VLAN_PCP;
        }

        public byte priority() {
            return this.vlanPcp;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.type().toString()).add("priority", Long.toHexString(this.vlanPcp)).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.vlanPcp});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof VlanPcpCriterion) {
                VlanPcpCriterion that = (VlanPcpCriterion)obj;
                return Objects.equals(this.vlanPcp, that.vlanPcp) && Objects.equals((Object)this.type(), (Object)that.type());
            }
            return false;
        }
    }

    public static final class VlanIdCriterion
    implements Criterion {
        private final VlanId vlanId;

        public VlanIdCriterion(VlanId vlanId) {
            this.vlanId = vlanId;
        }

        @Override
        public Criterion.Type type() {
            return Criterion.Type.VLAN_VID;
        }

        public VlanId vlanId() {
            return this.vlanId;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.type().toString()).add("vlanId", this.vlanId).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.vlanId});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof VlanIdCriterion) {
                VlanIdCriterion that = (VlanIdCriterion)obj;
                return Objects.equals(this.vlanId, that.vlanId) && Objects.equals((Object)this.type(), (Object)that.type());
            }
            return false;
        }
    }

    public static final class EthTypeCriterion
    implements Criterion {
        private static final int MASK = 65535;
        private final int ethType;

        public EthTypeCriterion(int ethType) {
            this.ethType = ethType & 0xFFFF;
        }

        @Override
        public Criterion.Type type() {
            return Criterion.Type.ETH_TYPE;
        }

        public int ethType() {
            return this.ethType;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.type().toString()).add("ethType", Long.toHexString(this.ethType)).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.ethType});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof EthTypeCriterion) {
                EthTypeCriterion that = (EthTypeCriterion)obj;
                return Objects.equals(this.ethType, that.ethType) && Objects.equals((Object)this.type(), (Object)that.type());
            }
            return false;
        }
    }

    public static final class EthCriterion
    implements Criterion {
        private final MacAddress mac;
        private final Criterion.Type type;

        public EthCriterion(MacAddress mac, Criterion.Type type) {
            this.mac = mac;
            this.type = type;
        }

        @Override
        public Criterion.Type type() {
            return this.type;
        }

        public MacAddress mac() {
            return this.mac;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.type().toString()).add("mac", this.mac).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.mac});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof EthCriterion) {
                EthCriterion that = (EthCriterion)obj;
                return Objects.equals(this.mac, that.mac) && Objects.equals((Object)this.type, (Object)that.type);
            }
            return false;
        }
    }

    public static final class MetadataCriterion
    implements Criterion {
        private final long metadata;

        public MetadataCriterion(long metadata) {
            this.metadata = metadata;
        }

        @Override
        public Criterion.Type type() {
            return Criterion.Type.METADATA;
        }

        public long metadata() {
            return this.metadata;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.type().toString()).add("metadata", Long.toHexString(this.metadata)).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.metadata});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof MetadataCriterion) {
                MetadataCriterion that = (MetadataCriterion)obj;
                return Objects.equals(this.metadata, that.metadata) && Objects.equals((Object)this.type(), (Object)that.type());
            }
            return false;
        }
    }

    public static final class PortCriterion
    implements Criterion {
        private final PortNumber port;
        private final Criterion.Type type;

        public PortCriterion(PortNumber port, Criterion.Type type) {
            this.port = port;
            this.type = type;
        }

        @Override
        public Criterion.Type type() {
            return this.type;
        }

        public PortNumber port() {
            return this.port;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.type().toString()).add("port", this.port).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.port});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof PortCriterion) {
                PortCriterion that = (PortCriterion)obj;
                return Objects.equals(this.port, that.port) && Objects.equals((Object)this.type(), (Object)that.type());
            }
            return false;
        }
    }
}

