/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow.instructions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.MplsLabel;
import org.onlab.packet.VlanId;
import org.onosproject.core.GroupId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.L0ModificationInstruction;
import org.onosproject.net.flow.instructions.L2ModificationInstruction;
import org.onosproject.net.flow.instructions.L3ModificationInstruction;

public final class Instructions {
    private Instructions() {
    }

    public static OutputInstruction createOutput(PortNumber number) {
        Preconditions.checkNotNull(number, "PortNumber cannot be null");
        return new OutputInstruction(number);
    }

    public static DropInstruction createDrop() {
        return new DropInstruction();
    }

    public static GroupInstruction createGroup(GroupId groupId) {
        Preconditions.checkNotNull(groupId, "GroupId cannot be null");
        return new GroupInstruction(groupId);
    }

    public static L0ModificationInstruction modL0Lambda(short lambda) {
        Preconditions.checkNotNull(lambda, "L0 lambda cannot be null");
        return new L0ModificationInstruction.ModLambdaInstruction(L0ModificationInstruction.L0SubType.LAMBDA, lambda);
    }

    public static L2ModificationInstruction modL2Src(MacAddress addr) {
        Preconditions.checkNotNull(addr, "Src l2 address cannot be null");
        return new L2ModificationInstruction.ModEtherInstruction(L2ModificationInstruction.L2SubType.ETH_SRC, addr);
    }

    public static L2ModificationInstruction modL2Dst(MacAddress addr) {
        Preconditions.checkNotNull(addr, "Dst l2 address cannot be null");
        return new L2ModificationInstruction.ModEtherInstruction(L2ModificationInstruction.L2SubType.ETH_DST, addr);
    }

    public static L2ModificationInstruction modVlanId(VlanId vlanId) {
        Preconditions.checkNotNull(vlanId, "VLAN id cannot be null");
        return new L2ModificationInstruction.ModVlanIdInstruction(vlanId);
    }

    public static L2ModificationInstruction modVlanPcp(Byte vlanPcp) {
        Preconditions.checkNotNull(vlanPcp, "VLAN Pcp cannot be null");
        return new L2ModificationInstruction.ModVlanPcpInstruction(vlanPcp);
    }

    public static L2ModificationInstruction stripVlanId() {
        return new L2ModificationInstruction.StripVlanInstruction();
    }

    public static L2ModificationInstruction modMplsLabel(MplsLabel mplsLabel) {
        Preconditions.checkNotNull(mplsLabel, "MPLS label cannot be null");
        return new L2ModificationInstruction.ModMplsLabelInstruction(mplsLabel);
    }

    public static L2ModificationInstruction decMplsTtl() {
        return new L2ModificationInstruction.ModMplsTtlInstruction();
    }

    public static L3ModificationInstruction modL3Src(IpAddress addr) {
        Preconditions.checkNotNull(addr, "Src l3 IPv4 address cannot be null");
        return new L3ModificationInstruction.ModIPInstruction(L3ModificationInstruction.L3SubType.IPV4_SRC, addr);
    }

    public static L3ModificationInstruction modL3Dst(IpAddress addr) {
        Preconditions.checkNotNull(addr, "Dst l3 IPv4 address cannot be null");
        return new L3ModificationInstruction.ModIPInstruction(L3ModificationInstruction.L3SubType.IPV4_DST, addr);
    }

    public static L3ModificationInstruction modL3IPv6Src(IpAddress addr) {
        Preconditions.checkNotNull(addr, "Src l3 IPv6 address cannot be null");
        return new L3ModificationInstruction.ModIPInstruction(L3ModificationInstruction.L3SubType.IPV6_SRC, addr);
    }

    public static L3ModificationInstruction modL3IPv6Dst(IpAddress addr) {
        Preconditions.checkNotNull(addr, "Dst l3 IPv6 address cannot be null");
        return new L3ModificationInstruction.ModIPInstruction(L3ModificationInstruction.L3SubType.IPV6_DST, addr);
    }

    public static L3ModificationInstruction modL3IPv6FlowLabel(int flowLabel) {
        return new L3ModificationInstruction.ModIPv6FlowLabelInstruction(flowLabel);
    }

    public static L3ModificationInstruction decNwTtl() {
        return new L3ModificationInstruction.ModTtlInstruction(L3ModificationInstruction.L3SubType.DEC_TTL);
    }

    public static L3ModificationInstruction copyTtlOut() {
        return new L3ModificationInstruction.ModTtlInstruction(L3ModificationInstruction.L3SubType.TTL_OUT);
    }

    public static L3ModificationInstruction copyTtlIn() {
        return new L3ModificationInstruction.ModTtlInstruction(L3ModificationInstruction.L3SubType.TTL_IN);
    }

    public static Instruction pushMpls() {
        return new L2ModificationInstruction.PushHeaderInstructions(L2ModificationInstruction.L2SubType.MPLS_PUSH, -30649);
    }

    public static Instruction popMpls() {
        return new L2ModificationInstruction.PushHeaderInstructions(L2ModificationInstruction.L2SubType.MPLS_POP, -30649);
    }

    public static Instruction popMpls(Short etherType) {
        Preconditions.checkNotNull(etherType, "Ethernet type cannot be null");
        return new L2ModificationInstruction.PushHeaderInstructions(L2ModificationInstruction.L2SubType.MPLS_POP, etherType);
    }

    public static Instruction popVlan() {
        return new L2ModificationInstruction.PopVlanInstruction(L2ModificationInstruction.L2SubType.VLAN_POP);
    }

    public static Instruction pushVlan() {
        return new L2ModificationInstruction.PushHeaderInstructions(L2ModificationInstruction.L2SubType.VLAN_PUSH, -32512);
    }

    public static Instruction transition(FlowRule.Type type) {
        Preconditions.checkNotNull(type, "Table type cannot be null");
        return new TableTypeTransition(type);
    }

    public static class TableTypeTransition
    implements Instruction {
        private final FlowRule.Type tableType;

        TableTypeTransition(FlowRule.Type type) {
            this.tableType = type;
        }

        @Override
        public Instruction.Type type() {
            return Instruction.Type.TABLE;
        }

        public FlowRule.Type tableType() {
            return this.tableType;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.type().toString()).add("tableType", (Object)this.tableType).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.tableType});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof TableTypeTransition) {
                TableTypeTransition that = (TableTypeTransition)obj;
                return Objects.equals((Object)this.tableType, (Object)that.tableType);
            }
            return false;
        }
    }

    public static final class GroupInstruction
    implements Instruction {
        private final GroupId groupId;

        private GroupInstruction(GroupId groupId) {
            this.groupId = groupId;
        }

        public GroupId groupId() {
            return this.groupId;
        }

        @Override
        public Instruction.Type type() {
            return Instruction.Type.GROUP;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.type().toString()).add("group ID", this.groupId.id()).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.groupId});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof GroupInstruction) {
                GroupInstruction that = (GroupInstruction)obj;
                return Objects.equals(this.groupId, that.groupId);
            }
            return false;
        }
    }

    public static final class OutputInstruction
    implements Instruction {
        private final PortNumber port;

        private OutputInstruction(PortNumber port) {
            this.port = port;
        }

        public PortNumber port() {
            return this.port;
        }

        @Override
        public Instruction.Type type() {
            return Instruction.Type.OUTPUT;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.type().toString()).add("port", this.port).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.port});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof OutputInstruction) {
                OutputInstruction that = (OutputInstruction)obj;
                return Objects.equals(this.port, that.port);
            }
            return false;
        }
    }

    public static final class DropInstruction
    implements Instruction {
        private DropInstruction() {
        }

        @Override
        public Instruction.Type type() {
            return Instruction.Type.DROP;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.type().toString()).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type()});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            return obj instanceof DropInstruction;
        }
    }
}

