/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow.instructions;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onlab.packet.MacAddress;
import org.onlab.packet.MplsLabel;
import org.onlab.packet.VlanId;
import org.onosproject.net.flow.instructions.Instruction;

public abstract class L2ModificationInstruction
implements Instruction {
    public abstract L2SubType subtype();

    @Override
    public final Instruction.Type type() {
        return Instruction.Type.L2MODIFICATION;
    }

    public static final class ModMplsTtlInstruction
    extends L2ModificationInstruction {
        ModMplsTtlInstruction() {
        }

        @Override
        public L2SubType subtype() {
            return L2SubType.DEC_MPLS_TTL;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.subtype().toString()).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.subtype()});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            return obj instanceof ModMplsTtlInstruction;
        }
    }

    public static final class ModMplsLabelInstruction
    extends L2ModificationInstruction {
        private final MplsLabel mplsLabel;

        ModMplsLabelInstruction(MplsLabel mplsLabel) {
            this.mplsLabel = mplsLabel;
        }

        public Integer label() {
            return this.mplsLabel.toInt();
        }

        @Override
        public L2SubType subtype() {
            return L2SubType.MPLS_LABEL;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.subtype().toString()).add("mpls", this.mplsLabel).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.subtype(), this.mplsLabel});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ModMplsLabelInstruction) {
                ModMplsLabelInstruction that = (ModMplsLabelInstruction)obj;
                return Objects.equals(this.mplsLabel, that.mplsLabel);
            }
            return false;
        }
    }

    public static final class PopVlanInstruction
    extends L2ModificationInstruction {
        private final L2SubType subtype;

        PopVlanInstruction(L2SubType subType) {
            this.subtype = subType;
        }

        @Override
        public L2SubType subtype() {
            return this.subtype;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.subtype().toString()).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.subtype});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof PopVlanInstruction) {
                PopVlanInstruction that = (PopVlanInstruction)obj;
                return Objects.equals((Object)this.subtype, (Object)that.subtype);
            }
            return false;
        }
    }

    public static final class StripVlanInstruction
    extends L2ModificationInstruction {
        StripVlanInstruction() {
        }

        @Override
        public L2SubType subtype() {
            return L2SubType.STRIP_VLAN;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.subtype().toString()).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.subtype()});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            return obj instanceof StripVlanInstruction;
        }
    }

    public static final class ModVlanPcpInstruction
    extends L2ModificationInstruction {
        private final Byte vlanPcp;

        ModVlanPcpInstruction(Byte vlanPcp) {
            this.vlanPcp = vlanPcp;
        }

        @Override
        public L2SubType subtype() {
            return L2SubType.VLAN_PCP;
        }

        public Byte vlanPcp() {
            return this.vlanPcp;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.subtype().toString()).add("pcp", Long.toHexString(this.vlanPcp.byteValue())).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.subtype(), this.vlanPcp});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ModVlanPcpInstruction) {
                ModVlanPcpInstruction that = (ModVlanPcpInstruction)obj;
                return Objects.equals(this.vlanPcp, that.vlanPcp);
            }
            return false;
        }
    }

    public static final class ModVlanIdInstruction
    extends L2ModificationInstruction {
        private final VlanId vlanId;

        ModVlanIdInstruction(VlanId vlanId) {
            this.vlanId = vlanId;
        }

        @Override
        public L2SubType subtype() {
            return L2SubType.VLAN_ID;
        }

        public VlanId vlanId() {
            return this.vlanId;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.subtype().toString()).add("id", this.vlanId).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.subtype(), this.vlanId});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ModVlanIdInstruction) {
                ModVlanIdInstruction that = (ModVlanIdInstruction)obj;
                return Objects.equals(this.vlanId, that.vlanId);
            }
            return false;
        }
    }

    public static final class PushHeaderInstructions
    extends L2ModificationInstruction {
        private final L2SubType subtype;
        private final short ethernetType;

        PushHeaderInstructions(L2SubType subType, short ethernetType) {
            this.subtype = subType;
            this.ethernetType = ethernetType;
        }

        public int ethernetType() {
            return Short.toUnsignedInt(this.ethernetType);
        }

        @Override
        public L2SubType subtype() {
            return this.subtype;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.subtype().toString()).add("ethernetType", String.format("0x%04x", this.ethernetType())).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.subtype, this.ethernetType});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof PushHeaderInstructions) {
                PushHeaderInstructions that = (PushHeaderInstructions)obj;
                return Objects.equals((Object)this.subtype, (Object)that.subtype) && Objects.equals(this.ethernetType, that.ethernetType);
            }
            return false;
        }
    }

    public static final class ModEtherInstruction
    extends L2ModificationInstruction {
        private final L2SubType subtype;
        private final MacAddress mac;

        ModEtherInstruction(L2SubType subType, MacAddress addr) {
            this.subtype = subType;
            this.mac = addr;
        }

        @Override
        public L2SubType subtype() {
            return this.subtype;
        }

        public MacAddress mac() {
            return this.mac;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.subtype().toString()).add("mac", this.mac).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.subtype, this.mac});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ModEtherInstruction) {
                ModEtherInstruction that = (ModEtherInstruction)obj;
                return Objects.equals(this.mac, that.mac) && Objects.equals((Object)this.subtype, (Object)that.subtype);
            }
            return false;
        }
    }

    public static enum L2SubType {
        ETH_SRC,
        ETH_DST,
        VLAN_ID,
        VLAN_PCP,
        STRIP_VLAN,
        MPLS_LABEL,
        MPLS_PUSH,
        MPLS_POP,
        DEC_MPLS_TTL,
        VLAN_POP,
        VLAN_PUSH;

    }
}

