/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.group;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onosproject.core.GroupId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.group.GroupBucket;
import org.onosproject.net.group.GroupDescription;

public final class DefaultGroupBucket
implements GroupBucket {
    private final GroupDescription.Type type;
    private final TrafficTreatment treatment;
    private final short weight;
    private final PortNumber watchPort;
    private final GroupId watchGroup;

    private DefaultGroupBucket(GroupDescription.Type type, TrafficTreatment treatment, short weight, PortNumber watchPort, GroupId watchGroup) {
        this.type = type;
        this.treatment = Preconditions.checkNotNull(treatment);
        this.weight = weight;
        this.watchPort = watchPort;
        this.watchGroup = watchGroup;
    }

    public static GroupBucket createIndirectGroupBucket(TrafficTreatment treatment) {
        return new DefaultGroupBucket(GroupDescription.Type.INDIRECT, treatment, -1, null, null);
    }

    public static GroupBucket createSelectGroupBucket(TrafficTreatment treatment) {
        return new DefaultGroupBucket(GroupDescription.Type.SELECT, treatment, 1, null, null);
    }

    public static GroupBucket createSelectGroupBucket(TrafficTreatment treatment, short weight) {
        if (weight == 0) {
            return null;
        }
        return new DefaultGroupBucket(GroupDescription.Type.SELECT, treatment, weight, null, null);
    }

    public static GroupBucket createFailoverGroupBucket(TrafficTreatment treatment, PortNumber watchPort, GroupId watchGroup) {
        Preconditions.checkArgument(watchPort != null || watchGroup != null);
        return new DefaultGroupBucket(GroupDescription.Type.FAILOVER, treatment, -1, watchPort, watchGroup);
    }

    @Override
    public GroupDescription.Type type() {
        return this.type;
    }

    @Override
    public TrafficTreatment treatment() {
        return this.treatment;
    }

    @Override
    public short weight() {
        return this.weight;
    }

    @Override
    public PortNumber watchPort() {
        return this.watchPort;
    }

    @Override
    public GroupId watchGroup() {
        return this.watchGroup;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.treatment});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultGroupBucket) {
            DefaultGroupBucket that = (DefaultGroupBucket)obj;
            return Objects.equals((Object)this.type, (Object)that.type) && this.treatment.instructions().containsAll(that.treatment.instructions()) && that.treatment.instructions().containsAll(this.treatment.instructions());
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("type", (Object)this.type).add("treatment", this.treatment).toString();
    }
}

