/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.group;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.group.GroupBuckets;
import org.onosproject.net.group.GroupDescription;
import org.onosproject.net.group.GroupKey;

public class DefaultGroupDescription
implements GroupDescription {
    private final GroupDescription.Type type;
    private final GroupBuckets buckets;
    private final GroupKey appCookie;
    private final ApplicationId appId;
    private final DeviceId deviceId;

    public DefaultGroupDescription(DeviceId deviceId, GroupDescription.Type type, GroupBuckets buckets, GroupKey appCookie, ApplicationId appId) {
        this.type = Preconditions.checkNotNull(type);
        this.deviceId = Preconditions.checkNotNull(deviceId);
        this.buckets = Preconditions.checkNotNull(buckets);
        this.appCookie = appCookie;
        this.appId = appId;
    }

    public DefaultGroupDescription(GroupDescription groupDesc) {
        this.type = groupDesc.type();
        this.deviceId = groupDesc.deviceId();
        this.buckets = groupDesc.buckets();
        this.appCookie = groupDesc.appCookie();
        this.appId = groupDesc.appId();
    }

    public DefaultGroupDescription(DeviceId deviceId, GroupDescription.Type type, GroupBuckets buckets) {
        this(deviceId, type, buckets, null, null);
    }

    @Override
    public GroupDescription.Type type() {
        return this.type;
    }

    @Override
    public DeviceId deviceId() {
        return this.deviceId;
    }

    @Override
    public ApplicationId appId() {
        return this.appId;
    }

    @Override
    public GroupKey appCookie() {
        return this.appCookie;
    }

    @Override
    public GroupBuckets buckets() {
        return this.buckets;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.deviceId, this.type, this.buckets});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultGroupDescription) {
            DefaultGroupDescription that = (DefaultGroupDescription)obj;
            return Objects.equals(this.deviceId, that.deviceId) && Objects.equals((Object)this.type, (Object)that.type) && Objects.equals(this.buckets, that.buckets);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("deviceId", this.deviceId).add("type", (Object)this.type).add("buckets", this.buckets).add("appId", this.appId).toString();
    }
}

