/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.group;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.onosproject.net.group.GroupBucket;

public final class GroupBuckets {
    private final List<GroupBucket> buckets;

    public GroupBuckets(List<GroupBucket> buckets) {
        this.buckets = ImmutableList.copyOf((Collection)Preconditions.checkNotNull(buckets));
    }

    public List<GroupBucket> buckets() {
        return this.buckets;
    }

    public int hashCode() {
        int result = 17;
        int combinedHash = 0;
        for (GroupBucket bucket : this.buckets) {
            combinedHash += bucket.hashCode();
        }
        result = 31 * result + combinedHash;
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof GroupBuckets) {
            return this.buckets.containsAll(((GroupBuckets)obj).buckets) && ((GroupBuckets)obj).buckets.containsAll(this.buckets);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("buckets", this.buckets).toString();
    }
}

