/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.group;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onosproject.core.GroupId;
import org.onosproject.net.group.GroupBuckets;
import org.onosproject.net.group.GroupDescription;

public final class GroupOperation {
    private final Type opType;
    private final GroupId groupId;
    private final GroupDescription.Type groupType;
    private final GroupBuckets buckets;

    private GroupOperation(Type opType, GroupId groupId, GroupDescription.Type groupType, GroupBuckets buckets) {
        this.opType = Preconditions.checkNotNull(opType);
        this.groupId = Preconditions.checkNotNull(groupId);
        this.groupType = Preconditions.checkNotNull(groupType);
        this.buckets = buckets;
    }

    public static GroupOperation createAddGroupOperation(GroupId groupId, GroupDescription.Type groupType, GroupBuckets buckets) {
        Preconditions.checkNotNull(buckets);
        return new GroupOperation(Type.ADD, groupId, groupType, buckets);
    }

    public static GroupOperation createModifyGroupOperation(GroupId groupId, GroupDescription.Type groupType, GroupBuckets buckets) {
        Preconditions.checkNotNull(buckets);
        return new GroupOperation(Type.MODIFY, groupId, groupType, buckets);
    }

    public static GroupOperation createDeleteGroupOperation(GroupId groupId, GroupDescription.Type groupType) {
        return new GroupOperation(Type.DELETE, groupId, groupType, null);
    }

    public Type opType() {
        return this.opType;
    }

    public GroupId groupId() {
        return this.groupId;
    }

    public GroupDescription.Type groupType() {
        return this.groupType;
    }

    public GroupBuckets buckets() {
        return this.buckets;
    }

    public int hashCode() {
        return this.buckets != null ? Objects.hash(new Object[]{this.groupId, this.opType, this.buckets}) : Objects.hash(new Object[]{this.groupId, this.opType});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof GroupOperation) {
            GroupOperation that = (GroupOperation)obj;
            return Objects.equals(this.groupId, that.groupId) && Objects.equals((Object)this.opType, (Object)that.opType) && Objects.equals(this.buckets, that.buckets);
        }
        return false;
    }

    public static enum Type {
        ADD,
        MODIFY,
        DELETE;

    }
}

