/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.onosproject.cluster.NodeId;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentState;
import org.onosproject.net.intent.Key;
import org.onosproject.store.Timestamp;

public class IntentData {
    private Intent intent;
    private IntentState state;
    private Timestamp version;
    private NodeId origin;
    private List<Intent> installables;

    public IntentData(Intent intent, IntentState state, Timestamp version) {
        this.intent = intent;
        this.state = state;
        this.version = version;
    }

    protected IntentData() {
    }

    public Intent intent() {
        return this.intent;
    }

    public IntentState state() {
        return this.state;
    }

    public Key key() {
        return this.intent.key();
    }

    public Timestamp version() {
        return this.version;
    }

    public void setOrigin(NodeId origin) {
        this.origin = origin;
    }

    public NodeId origin() {
        return this.origin;
    }

    public void setState(IntentState newState) {
        this.state = newState;
    }

    public void setVersion(Timestamp version) {
        this.version = version;
    }

    public void setInstallables(List<Intent> installables) {
        this.installables = ImmutableList.copyOf(installables);
    }

    public List<Intent> installables() {
        return this.installables;
    }

    public int hashCode() {
        return Objects.hash(this.intent, this.version);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IntentData other = (IntentData)obj;
        return Objects.equals(this.intent, other.intent) && Objects.equals(this.version, other.version);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("key", this.key()).add("state", (Object)this.state()).add("version", this.version()).add("intent", this.intent()).add("installables", this.installables()).toString();
    }
}

