/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.onosproject.core.ApplicationId;

public abstract class Key {
    private final long hash;
    private static final HashFunction HASH_FN = Hashing.md5();

    protected Key(long hash) {
        this.hash = hash;
    }

    public long hash() {
        return this.hash;
    }

    public int hashCode() {
        return (int)(this.hash() ^ this.hash() >>> 32);
    }

    public abstract boolean equals(Object var1);

    public static Key of(String key, ApplicationId appId) {
        return new StringKey(key, appId);
    }

    public static Key of(long key, ApplicationId appId) {
        return new LongKey(key, appId);
    }

    private static final class LongKey
    extends Key {
        private final ApplicationId appId;
        private final long key;

        private LongKey(long key, ApplicationId appId) {
            super(HASH_FN.newHasher().putShort(appId.id()).putLong(key).hash().asLong());
            this.key = key;
            this.appId = appId;
        }

        public String toString() {
            return "0x" + Long.toHexString(this.key);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            LongKey other = (LongKey)obj;
            return this.hash() == other.hash() && this.key == other.key && Objects.equals(this.appId, other.appId);
        }
    }

    private static final class StringKey
    extends Key {
        private final ApplicationId appId;
        private final String key;

        private StringKey(String key, ApplicationId appId) {
            super(HASH_FN.newHasher().putShort(appId.id()).putString(key, StandardCharsets.UTF_8).hash().asLong());
            this.key = key;
            this.appId = appId;
        }

        public String toString() {
            return this.key;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            StringKey other = (StringKey)obj;
            return this.hash() == other.hash() && Objects.equals(this.appId, other.appId) && Objects.equals(this.key, other.key);
        }
    }
}

