/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Link;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.ConnectivityIntent;
import org.onosproject.net.intent.Constraint;

public final class LinkCollectionIntent
extends ConnectivityIntent {
    private final Set<Link> links;
    private final Set<ConnectPoint> ingressPoints;
    private final Set<ConnectPoint> egressPoints;

    public LinkCollectionIntent(ApplicationId appId, TrafficSelector selector, TrafficTreatment treatment, Set<Link> links, ConnectPoint ingressPoint, ConnectPoint egressPoint) {
        this(appId, selector, treatment, links, ingressPoint, egressPoint, Collections.emptyList(), 100);
    }

    public LinkCollectionIntent(ApplicationId appId, TrafficSelector selector, TrafficTreatment treatment, Set<Link> links, ConnectPoint ingressPoint, ConnectPoint egressPoint, List<Constraint> constraints, int priority) {
        super(appId, LinkCollectionIntent.resources(links), selector, treatment, constraints, priority);
        this.links = links;
        this.ingressPoints = ImmutableSet.of(ingressPoint);
        this.egressPoints = ImmutableSet.of(egressPoint);
    }

    public LinkCollectionIntent(ApplicationId appId, TrafficSelector selector, TrafficTreatment treatment, Set<Link> links, Set<ConnectPoint> ingressPoints, Set<ConnectPoint> egressPoints, List<Constraint> constraints, int priority) {
        super(appId, LinkCollectionIntent.resources(links), selector, treatment, constraints, priority);
        this.links = links;
        this.ingressPoints = ImmutableSet.copyOf(ingressPoints);
        this.egressPoints = ImmutableSet.copyOf(egressPoints);
    }

    protected LinkCollectionIntent() {
        this.links = null;
        this.ingressPoints = null;
        this.egressPoints = null;
    }

    public Set<Link> links() {
        return this.links;
    }

    public Set<ConnectPoint> ingressPoints() {
        return this.ingressPoints;
    }

    public Set<ConnectPoint> egressPoints() {
        return this.egressPoints;
    }

    @Override
    public boolean isInstallable() {
        return true;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("id", this.id()).add("key", this.key()).add("appId", this.appId()).add("priority", this.priority()).add("resources", this.resources()).add("selector", this.selector()).add("treatment", this.treatment()).add("links", this.links()).add("ingress", this.ingressPoints()).add("egress", this.egressPoints()).toString();
    }
}

