/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.onlab.packet.MplsLabel;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Link;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.ConnectivityIntent;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.constraint.LinkTypeConstraint;

public final class MplsIntent
extends ConnectivityIntent {
    private final ConnectPoint ingressPoint;
    private final Optional<MplsLabel> ingressLabel;
    private final ConnectPoint egressPoint;
    private final Optional<MplsLabel> egressLabel;

    public MplsIntent(ApplicationId appId, TrafficSelector selector, TrafficTreatment treatment, ConnectPoint ingressPoint, Optional<MplsLabel> ingressLabel, ConnectPoint egressPoint, Optional<MplsLabel> egressLabel) {
        this(appId, selector, treatment, ingressPoint, ingressLabel, egressPoint, egressLabel, ImmutableList.of(new LinkTypeConstraint(false, Link.Type.OPTICAL)));
    }

    public MplsIntent(ApplicationId appId, TrafficSelector selector, TrafficTreatment treatment, ConnectPoint ingressPoint, Optional<MplsLabel> ingressLabel, ConnectPoint egressPoint, Optional<MplsLabel> egressLabel, List<Constraint> constraints) {
        super(appId, Collections.emptyList(), selector, treatment, constraints, 100);
        Preconditions.checkNotNull(ingressPoint);
        Preconditions.checkNotNull(egressPoint);
        Preconditions.checkArgument(!ingressPoint.equals(egressPoint), "ingress and egress should be different (ingress: %s, egress: %s)", ingressPoint, egressPoint);
        Preconditions.checkNotNull(ingressLabel);
        Preconditions.checkNotNull(egressLabel);
        this.ingressPoint = ingressPoint;
        this.ingressLabel = ingressLabel;
        this.egressPoint = egressPoint;
        this.egressLabel = egressLabel;
    }

    protected MplsIntent() {
        this.ingressPoint = null;
        this.ingressLabel = null;
        this.egressPoint = null;
        this.egressLabel = null;
    }

    public ConnectPoint ingressPoint() {
        return this.ingressPoint;
    }

    public ConnectPoint egressPoint() {
        return this.egressPoint;
    }

    public Optional<MplsLabel> ingressLabel() {
        return this.ingressLabel;
    }

    public Optional<MplsLabel> egressLabel() {
        return this.egressLabel;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("id", this.id()).add("appId", this.appId()).add("priority", this.priority()).add("selector", this.selector()).add("treatment", this.treatment()).add("ingressPoint", this.ingressPoint).add("ingressLabel", this.ingressLabel).add("egressPoint", this.egressPoint).add("egressLabel", this.egressLabel).add("constraints", this.constraints()).toString();
    }
}

