/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.Link;
import org.onosproject.net.Path;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.ConnectivityIntent;
import org.onosproject.net.intent.Constraint;

public class PathIntent
extends ConnectivityIntent {
    private final Path path;

    public PathIntent(ApplicationId appId, TrafficSelector selector, TrafficTreatment treatment, Path path) {
        this(appId, selector, treatment, path, Collections.emptyList(), 100);
    }

    public PathIntent(ApplicationId appId, TrafficSelector selector, TrafficTreatment treatment, Path path, List<Constraint> constraints, int priority) {
        super(appId, PathIntent.resources(path.links()), selector, treatment, constraints, priority);
        PathIntent.validate(path.links());
        this.path = path;
    }

    protected PathIntent() {
        this.path = null;
    }

    public static void validate(List<Link> links) {
        Preconditions.checkArgument(Iterables.all(links, new Predicate<Link>(){

            @Override
            public boolean apply(Link link) {
                return !link.src().elementId().equals(link.dst().elementId());
            }
        }), "element of src and dst in a link must be different: {}", links);
        boolean adjacentSame = true;
        for (int i = 0; i < links.size() - 1; ++i) {
            if (links.get(i).dst().elementId().equals(links.get(i + 1).src().elementId())) continue;
            adjacentSame = false;
            break;
        }
        Preconditions.checkArgument(adjacentSame, "adjacent links must share the same element: {}", links);
    }

    public Path path() {
        return this.path;
    }

    @Override
    public boolean isInstallable() {
        return true;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("id", this.id()).add("appId", this.appId()).add("priority", this.priority()).add("resources", this.resources()).add("selector", this.selector()).add("treatment", this.treatment()).add("constraints", this.constraints()).add("path", this.path).toString();
    }
}

