/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Link;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.ConnectivityIntent;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.Key;
import org.onosproject.net.intent.constraint.LinkTypeConstraint;

public final class PointToPointIntent
extends ConnectivityIntent {
    private final ConnectPoint ingressPoint;
    private final ConnectPoint egressPoint;

    public PointToPointIntent(ApplicationId appId, Key key, TrafficSelector selector, TrafficTreatment treatment, ConnectPoint ingressPoint, ConnectPoint egressPoint, List<Constraint> constraints, int priority) {
        super(appId, key, Collections.emptyList(), selector, treatment, constraints, priority);
        Preconditions.checkNotNull(ingressPoint);
        Preconditions.checkNotNull(egressPoint);
        Preconditions.checkArgument(!ingressPoint.equals(egressPoint), "ingress and egress should be different (ingress: %s, egress: %s)", ingressPoint, egressPoint);
        this.ingressPoint = ingressPoint;
        this.egressPoint = egressPoint;
    }

    public PointToPointIntent(ApplicationId appId, TrafficSelector selector, TrafficTreatment treatment, ConnectPoint ingressPoint, ConnectPoint egressPoint) {
        this(appId, null, selector, treatment, ingressPoint, egressPoint, ImmutableList.of(new LinkTypeConstraint(false, Link.Type.OPTICAL)), 100);
    }

    public PointToPointIntent(ApplicationId appId, TrafficSelector selector, TrafficTreatment treatment, ConnectPoint ingressPoint, ConnectPoint egressPoint, List<Constraint> constraints, int priority) {
        super(appId, null, Collections.emptyList(), selector, treatment, constraints, priority);
        Preconditions.checkNotNull(ingressPoint);
        Preconditions.checkNotNull(egressPoint);
        Preconditions.checkArgument(!ingressPoint.equals(egressPoint), "ingress and egress should be different (ingress: %s, egress: %s)", ingressPoint, egressPoint);
        this.ingressPoint = ingressPoint;
        this.egressPoint = egressPoint;
    }

    protected PointToPointIntent() {
        this.ingressPoint = null;
        this.egressPoint = null;
    }

    public ConnectPoint ingressPoint() {
        return this.ingressPoint;
    }

    public ConnectPoint egressPoint() {
        return this.egressPoint;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("id", this.id()).add("key", this.key()).add("appId", this.appId()).add("priority", this.priority()).add("resources", this.resources()).add("selector", this.selector()).add("treatment", this.treatment()).add("ingress", this.ingressPoint).add("egress", this.egressPoint).add("constraints", this.constraints()).toString();
    }
}

