/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.HostId;
import org.onosproject.net.Link;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.ConnectivityIntent;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.Key;
import org.onosproject.net.intent.constraint.LinkTypeConstraint;

public final class TwoWayP2PIntent
extends ConnectivityIntent {
    private final ConnectPoint one;
    private final ConnectPoint two;

    public TwoWayP2PIntent(ApplicationId appId, ConnectPoint one, ConnectPoint two) {
        this(appId, one, two, DefaultTrafficSelector.emptySelector(), DefaultTrafficTreatment.emptyTreatment(), ImmutableList.of(new LinkTypeConstraint(false, Link.Type.OPTICAL)));
    }

    public TwoWayP2PIntent(ApplicationId appId, ConnectPoint one, ConnectPoint two, TrafficSelector selector, TrafficTreatment treatment) {
        this(appId, one, two, selector, treatment, ImmutableList.of(new LinkTypeConstraint(false, Link.Type.OPTICAL)));
    }

    public TwoWayP2PIntent(ApplicationId appId, ConnectPoint one, ConnectPoint two, TrafficSelector selector, TrafficTreatment treatment, List<Constraint> constraints) {
        this(appId, null, one, two, selector, treatment, constraints);
    }

    public TwoWayP2PIntent(ApplicationId appId, Key key, ConnectPoint one, ConnectPoint two, TrafficSelector selector, TrafficTreatment treatment, List<Constraint> constraints) {
        super(appId, key, Collections.emptyList(), selector, treatment, constraints, 100);
        this.one = Preconditions.checkNotNull(one);
        this.two = Preconditions.checkNotNull(two);
    }

    private static HostId min(HostId one, HostId two) {
        return one.hashCode() < two.hashCode() ? one : two;
    }

    private static HostId max(HostId one, HostId two) {
        return one.hashCode() >= two.hashCode() ? one : two;
    }

    public ConnectPoint one() {
        return this.one;
    }

    public ConnectPoint two() {
        return this.two;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("id", this.id()).add("key", this.key()).add("appId", this.appId()).add("priority", this.priority()).add("resources", this.resources()).add("selector", this.selector()).add("treatment", this.treatment()).add("constraints", this.constraints()).add("one", this.one).add("two", this.two).toString();
    }
}

