/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.resource;

import java.util.Objects;
import org.onosproject.net.resource.LinkResource;

public final class Bandwidth
extends LinkResource {
    private final double bandwidth;

    private Bandwidth(double bandwidth) {
        this.bandwidth = bandwidth;
    }

    private Bandwidth() {
        this.bandwidth = 0.0;
    }

    @Deprecated
    public static Bandwidth valueOf(double bandwidth) {
        return Bandwidth.bps(bandwidth);
    }

    public static Bandwidth bps(double bandwidth) {
        return new Bandwidth(bandwidth);
    }

    public static Bandwidth kbps(double bandwidth) {
        return new Bandwidth(bandwidth * 1000.0);
    }

    public static Bandwidth mbps(double bandwidth) {
        return new Bandwidth(bandwidth * 1000000.0);
    }

    public static Bandwidth gbps(double bandwidth) {
        return new Bandwidth(bandwidth * 1.0E9);
    }

    public double toDouble() {
        return this.bandwidth;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Bandwidth) {
            Bandwidth that = (Bandwidth)obj;
            return Objects.equals(this.bandwidth, that.bandwidth);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.bandwidth);
    }

    public String toString() {
        return String.valueOf(this.bandwidth);
    }
}

