/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store;

import com.google.common.base.Preconditions;
import java.util.List;
import org.onosproject.event.Event;
import org.onosproject.store.Store;
import org.onosproject.store.StoreDelegate;

public class AbstractStore<E extends Event, D extends StoreDelegate<E>>
implements Store<E, D> {
    protected D delegate;

    @Override
    public void setDelegate(D delegate) {
        Preconditions.checkState(this.delegate == null || this.delegate == delegate, "Store delegate already set");
        this.delegate = delegate;
    }

    @Override
    public void unsetDelegate(D delegate) {
        if (this.delegate == delegate) {
            this.delegate = null;
        }
    }

    @Override
    public boolean hasDelegate() {
        return this.delegate != null;
    }

    protected void notifyDelegate(E event) {
        if (this.delegate != null) {
            this.delegate.notify(event);
        }
    }

    protected void notifyDelegate(List<E> events) {
        for (Event event : events) {
            this.notifyDelegate(event);
        }
    }
}

