/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.cluster.messaging;

import com.google.common.base.Charsets;
import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import org.onlab.util.ByteArraySizeHashPrinter;
import org.onosproject.cluster.NodeId;
import org.onosproject.store.cluster.messaging.MessageSubject;

public class ClusterMessage {
    private final NodeId sender;
    private final MessageSubject subject;
    private final byte[] payload;

    public ClusterMessage(NodeId sender, MessageSubject subject, byte[] payload) {
        this.sender = sender;
        this.subject = subject;
        this.payload = payload;
    }

    public NodeId sender() {
        return this.sender;
    }

    public MessageSubject subject() {
        return this.subject;
    }

    public byte[] payload() {
        return this.payload;
    }

    public void respond(byte[] data) throws IOException {
        throw new IllegalStateException("One can only respond to message received from others.");
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("sender", this.sender).add("subject", this.subject).add("payload", ByteArraySizeHashPrinter.of(this.payload)).toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ClusterMessage)) {
            return false;
        }
        ClusterMessage that = (ClusterMessage)o;
        return Objects.equals(this.sender, that.sender) && Objects.equals(this.subject, that.subject) && Arrays.equals(this.payload, that.payload);
    }

    public byte[] getBytes() {
        byte[] senderBytes = this.sender.toString().getBytes(Charsets.UTF_8);
        byte[] subjectBytes = this.subject.value().getBytes(Charsets.UTF_8);
        int capacity = 12 + senderBytes.length + subjectBytes.length + this.payload.length;
        ByteBuffer buffer = ByteBuffer.allocate(capacity);
        buffer.putInt(senderBytes.length);
        buffer.put(senderBytes);
        buffer.putInt(subjectBytes.length);
        buffer.put(subjectBytes);
        buffer.putInt(this.payload.length);
        buffer.put(this.payload);
        return buffer.array();
    }

    public static ClusterMessage fromBytes(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        byte[] senderBytes = new byte[buffer.getInt()];
        buffer.get(senderBytes);
        byte[] subjectBytes = new byte[buffer.getInt()];
        buffer.get(subjectBytes);
        byte[] payloadBytes = new byte[buffer.getInt()];
        buffer.get(payloadBytes);
        return new ClusterMessage(new NodeId(new String(senderBytes, Charsets.UTF_8)), new MessageSubject(new String(subjectBytes, Charsets.UTF_8)), payloadBytes);
    }

    public int hashCode() {
        return Objects.hash(this.sender, this.subject, this.payload);
    }
}

