/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;

public class UpdateOperation<K, V> {
    private Type type;
    private String tableName;
    private K key;
    private V value;
    private V currentValue;
    private long currentVersion = -1L;

    public Type type() {
        return this.type;
    }

    public String tableName() {
        return this.tableName;
    }

    public K key() {
        return this.key;
    }

    public V value() {
        return this.value;
    }

    public V currentValue() {
        return this.currentValue;
    }

    public long currentVersion() {
        return this.currentVersion;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("type", (Object)this.type).add("tableName", this.tableName).add("key", this.key).add("value", this.value).add("currentValue", this.currentValue).add("currentVersion", this.currentVersion).toString();
    }

    public static <K, V> Builder<K, V> newBuilder() {
        return new Builder();
    }

    public static final class Builder<K, V> {
        private UpdateOperation<K, V> operation = new UpdateOperation();

        public UpdateOperation<K, V> build() {
            this.validateInputs();
            return this.operation;
        }

        public Builder<K, V> withType(Type type) {
            ((UpdateOperation)this.operation).type = Preconditions.checkNotNull(type, "type cannot be null");
            return this;
        }

        public Builder<K, V> withTableName(String tableName) {
            ((UpdateOperation)this.operation).tableName = Preconditions.checkNotNull(tableName, "tableName cannot be null");
            return this;
        }

        public Builder<K, V> withKey(K key) {
            ((UpdateOperation)this.operation).key = Preconditions.checkNotNull(key, "key cannot be null");
            return this;
        }

        public Builder<K, V> withCurrentValue(V value) {
            ((UpdateOperation)this.operation).currentValue = Preconditions.checkNotNull(value, "currentValue cannot be null");
            return this;
        }

        public Builder<K, V> withValue(V value) {
            ((UpdateOperation)this.operation).value = Preconditions.checkNotNull(value, "value cannot be null");
            return this;
        }

        public Builder<K, V> withCurrentVersion(long version) {
            Preconditions.checkArgument(version >= 0L, "version cannot be negative");
            ((UpdateOperation)this.operation).currentVersion = version;
            return this;
        }

        private void validateInputs() {
            Preconditions.checkNotNull(((UpdateOperation)this.operation).type, "type must be specified");
            Preconditions.checkNotNull(((UpdateOperation)this.operation).tableName, "table name must be specified");
            Preconditions.checkNotNull(((UpdateOperation)this.operation).key, "key must be specified");
            switch (((UpdateOperation)this.operation).type) {
                case PUT: 
                case PUT_IF_ABSENT: {
                    Preconditions.checkNotNull(((UpdateOperation)this.operation).value, "value must be specified.");
                    break;
                }
                case PUT_IF_VERSION_MATCH: {
                    Preconditions.checkNotNull(((UpdateOperation)this.operation).value, "value must be specified.");
                    Preconditions.checkState(((UpdateOperation)this.operation).currentVersion >= 0L, "current version must be specified");
                    break;
                }
                case PUT_IF_VALUE_MATCH: {
                    Preconditions.checkNotNull(((UpdateOperation)this.operation).value, "value must be specified.");
                    Preconditions.checkNotNull(((UpdateOperation)this.operation).currentValue, "currentValue must be specified.");
                    break;
                }
                case REMOVE: {
                    break;
                }
                case REMOVE_IF_VERSION_MATCH: {
                    Preconditions.checkState(((UpdateOperation)this.operation).currentVersion >= 0L, "current version must be specified");
                    break;
                }
                case REMOVE_IF_VALUE_MATCH: {
                    Preconditions.checkNotNull(((UpdateOperation)this.operation).currentValue, "currentValue must be specified.");
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown operation type");
                }
            }
        }
    }

    public static enum Type {
        PUT,
        PUT_IF_ABSENT,
        PUT_IF_VERSION_MATCH,
        PUT_IF_VALUE_MATCH,
        REMOVE,
        REMOVE_IF_VERSION_MATCH,
        REMOVE_IF_VALUE_MATCH;

    }
}

