/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import java.util.List;
import org.onosproject.ui.UiMessageHandlerFactory;
import org.onosproject.ui.UiView;

public class UiExtension {
    private static final String VIEW_PREFIX = "app/view/";
    private final String prefix;
    private final ClassLoader classLoader;
    private final List<UiView> views;
    private final UiMessageHandlerFactory messageHandlerFactory;

    public UiExtension(List<UiView> views, UiMessageHandlerFactory messageHandlerFactory, ClassLoader classLoader) {
        this(views, messageHandlerFactory, null, classLoader);
    }

    public UiExtension(List<UiView> views, UiMessageHandlerFactory messageHandlerFactory, String path, ClassLoader classLoader) {
        this.views = Preconditions.checkNotNull(ImmutableList.copyOf(views), "Views cannot be null");
        this.messageHandlerFactory = messageHandlerFactory;
        this.prefix = path != null ? path + "/" : "";
        this.classLoader = Preconditions.checkNotNull(classLoader, "Class loader must be specified");
    }

    public InputStream css() {
        return this.classLoader.getResourceAsStream(this.prefix + "css.html");
    }

    public InputStream js() {
        return this.classLoader.getResourceAsStream(this.prefix + "js.html");
    }

    public List<UiView> views() {
        return this.views;
    }

    public InputStream resource(String viewId, String path) {
        InputStream is = this.classLoader.getResourceAsStream(VIEW_PREFIX + viewId + "/" + path);
        return is;
    }

    public UiMessageHandlerFactory messageHandlerFactory() {
        return this.messageHandlerFactory;
    }
}

