/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.util.Set;
import org.onlab.osgi.ServiceDirectory;
import org.onosproject.ui.UiConnection;

public abstract class UiMessageHandler {
    private final Set<String> messageTypes;
    private UiConnection connection;
    private ServiceDirectory directory;
    protected final ObjectMapper mapper = new ObjectMapper();

    protected UiMessageHandler(Set<String> messageTypes) {
        this.messageTypes = Preconditions.checkNotNull(messageTypes, "Message types cannot be null");
        Preconditions.checkArgument(!messageTypes.isEmpty(), "Message types cannot be empty");
    }

    public Set<String> messageTypes() {
        return this.messageTypes;
    }

    public abstract void process(ObjectNode var1);

    public void init(UiConnection connection, ServiceDirectory directory) {
        this.connection = connection;
        this.directory = directory;
    }

    public void destroy() {
        this.connection = null;
        this.directory = null;
    }

    public UiConnection connection() {
        return this.connection;
    }

    public ServiceDirectory directory() {
        return this.directory;
    }

    protected <T> T get(Class<T> serviceClass) {
        return this.directory.get(serviceClass);
    }

    protected ObjectNode envelope(String type, long sid, ObjectNode payload) {
        ObjectNode event = this.mapper.createObjectNode();
        event.put("event", type);
        if (sid > 0L) {
            event.put("sid", sid);
        }
        event.set("payload", payload);
        return event;
    }
}

