/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.onlab.packet.BasePacket;
import org.onlab.packet.Data;
import org.onlab.packet.IPacket;
import org.onlab.packet.IPv4;

public class MPLS
extends BasePacket {
    public static final int ADDRESS_LENGTH = 4;
    public static final byte PROTOCOL_IPV4 = 1;
    public static final byte PROTOCOL_MPLS = 6;
    public static final Map<Byte, Class<? extends IPacket>> PROTOCOL_CLASS_MAP = new HashMap<Byte, Class<? extends IPacket>>();
    protected int label;
    protected byte bos = 1;
    protected byte ttl;
    protected byte protocol = 1;

    @Override
    public byte[] serialize() {
        byte[] payloadData = null;
        if (this.payload != null) {
            this.payload.setParent(this);
            payloadData = this.payload.serialize();
        }
        byte[] data = new byte[4 + (payloadData != null ? payloadData.length : 0)];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.putInt((this.label & 0xFFFFF) << 12 | ((this.bos & 1) << 8 | this.ttl & 0xFF));
        if (payloadData != null) {
            bb.put(payloadData);
        }
        return data;
    }

    @Override
    public IPacket deserialize(byte[] data, int offset, int length) {
        IPacket payload;
        ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
        int mplsheader = bb.getInt();
        this.label = (mplsheader & 0xFFFFF000) >> 12;
        this.bos = (byte)((mplsheader & 0x100) >> 8);
        this.bos = (byte)(mplsheader & 0xFF);
        this.protocol = (byte)(this.bos == 1 ? 1 : 6);
        if (IPv4.PROTOCOL_CLASS_MAP.containsKey(this.protocol)) {
            Class<? extends IPacket> clazz = IPv4.PROTOCOL_CLASS_MAP.get(this.protocol);
            try {
                payload = clazz.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Error parsing payload for MPLS packet", e);
            }
        } else {
            payload = new Data();
        }
        this.payload = payload.deserialize(data, bb.position(), bb.limit() - bb.position());
        this.payload.setParent(this);
        return this;
    }

    public int getLabel() {
        return this.label;
    }

    public void setLabel(int label) {
        this.label = label;
    }

    public byte getTtl() {
        return this.ttl;
    }

    public void setTtl(byte ttl) {
        this.ttl = ttl;
    }

    static {
        PROTOCOL_CLASS_MAP.put((byte)1, IPv4.class);
        PROTOCOL_CLASS_MAP.put((byte)6, MPLS.class);
    }
}

