/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

public class MplsLabel {
    private final int mplsLabel;
    public static final int MAX_MPLS = 1048575;

    protected MplsLabel(int value) {
        this.mplsLabel = value;
    }

    public static MplsLabel mplsLabel(int value) {
        if (value < 0 || value > 1048575) {
            String errorMsg = "MPLS label value " + value + " is not in the interval [0, 0xFFFFF]";
            throw new IllegalArgumentException(errorMsg);
        }
        return new MplsLabel(value);
    }

    public int toInt() {
        return this.mplsLabel;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MplsLabel) {
            MplsLabel other = (MplsLabel)obj;
            if (this.mplsLabel == other.mplsLabel) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.mplsLabel;
    }

    public String toString() {
        return String.valueOf(this.mplsLabel);
    }
}

