/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import com.google.common.base.Preconditions;
import java.util.Timer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.onlab.util.SharedExecutorService;
import org.onlab.util.Tools;

public final class SharedExecutors {
    public static final int DEFAULT_POOL_SIZE = 30;
    private static SharedExecutorService singleThreadExecutor = new SharedExecutorService(Executors.newSingleThreadExecutor(Tools.groupedThreads("onos/shared", "onos-single-executor")));
    private static SharedExecutorService poolThreadExecutor = new SharedExecutorService(Executors.newFixedThreadPool(30, Tools.groupedThreads("onos/shared", "onos-pool-executor-%d")));
    private static SharedTimer sharedTimer = new SharedTimer();

    private SharedExecutors() {
    }

    public static ExecutorService getSingleThreadExecutor() {
        return singleThreadExecutor;
    }

    public static ExecutorService getPoolThreadExecutor() {
        return poolThreadExecutor;
    }

    public static Timer getTimer() {
        return sharedTimer;
    }

    public static void setPoolSize(int poolSize) {
        Preconditions.checkArgument(poolSize > 0, "Shared pool size size must be greater than 0");
        poolThreadExecutor.setBackingExecutor(Executors.newFixedThreadPool(poolSize, Tools.groupedThreads("onos/shared", "onos-pool-executor-%d")));
    }

    public static void shutdown() {
        SharedExecutors.sharedTimer.shutdown();
        singleThreadExecutor.backingExecutor().shutdown();
        poolThreadExecutor.backingExecutor().shutdown();
    }

    private static class SharedTimer
    extends Timer {
        public SharedTimer() {
            super("onos-shared-timer");
        }

        @Override
        public void cancel() {
            throw new UnsupportedOperationException("Cancel of shared timer is not allowed");
        }

        private void shutdown() {
            super.cancel();
        }
    }
}

