/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.core;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Objects;

public final class Version {
    public static final String FORMAT = "%d.%d.%s.%s";
    public static final String FORMAT_SHORT = "%d.%d.%s";
    private static final String NEGATIVE = "Version segment cannot be negative";
    private final int major;
    private final int minor;
    private final String patch;
    private final String build;
    private final String format;

    private Version(int major, int minor, String patch, String build) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.build = build;
        this.format = Strings.isNullOrEmpty(build) ? String.format(FORMAT_SHORT, major, minor, patch) : String.format(FORMAT, major, minor, patch, build);
    }

    public static Version version(int major, int minor, String patch, String build) {
        Preconditions.checkArgument(major > 0, NEGATIVE);
        Preconditions.checkArgument(minor > 0, NEGATIVE);
        return new Version(major, minor, patch, build);
    }

    public static Version version(String string) {
        String[] fields = string.split("[.-]");
        return new Version(Integer.parseInt(fields[0]), Integer.parseInt(fields[1]), fields[2], fields.length == 4 ? fields[3] : null);
    }

    public int major() {
        return this.major;
    }

    public int minor() {
        return this.minor;
    }

    public String patch() {
        return this.patch;
    }

    public String build() {
        return this.build;
    }

    public String toString() {
        return this.format;
    }

    public int hashCode() {
        return Objects.hash(this.format);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Version) {
            Version other = (Version)obj;
            return Objects.equals(this.format, other.format);
        }
        return false;
    }
}

