/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.onosproject.net.SparseAnnotations;

public final class DefaultAnnotations
implements SparseAnnotations {
    public static final SparseAnnotations EMPTY = DefaultAnnotations.builder().build();
    private final Map<String, String> map;

    private DefaultAnnotations() {
        this.map = null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultAnnotations that = (DefaultAnnotations)o;
        return Objects.equals(this.map, that.map);
    }

    public int hashCode() {
        return Objects.hashCode(this.map);
    }

    private DefaultAnnotations(Map<String, String> map) {
        this.map = map;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DefaultAnnotations merge(DefaultAnnotations annotations, SparseAnnotations sparseAnnotations) {
        Preconditions.checkNotNull(annotations, "Annotations cannot be null");
        if (sparseAnnotations == null || sparseAnnotations.keys().isEmpty()) {
            return annotations;
        }
        HashMap<String, String> merged = DefaultAnnotations.copy(annotations.map);
        for (String key : sparseAnnotations.keys()) {
            if (sparseAnnotations.isRemoved(key)) {
                merged.remove(key);
                continue;
            }
            merged.put(key, sparseAnnotations.value(key));
        }
        return new DefaultAnnotations(merged);
    }

    public static SparseAnnotations union(SparseAnnotations annotations, SparseAnnotations sparseAnnotations) {
        HashMap<String, String> newMap;
        if (sparseAnnotations == null || sparseAnnotations.keys().isEmpty()) {
            return annotations;
        }
        if (annotations instanceof DefaultAnnotations) {
            newMap = DefaultAnnotations.copy(((DefaultAnnotations)annotations).map);
        } else {
            newMap = new HashMap(annotations.keys().size() + sparseAnnotations.keys().size());
            DefaultAnnotations.putAllSparseAnnotations(newMap, annotations);
        }
        DefaultAnnotations.putAllSparseAnnotations(newMap, sparseAnnotations);
        return new DefaultAnnotations(newMap);
    }

    private static void putAllSparseAnnotations(HashMap<String, String> newMap, SparseAnnotations sparseAnnotations) {
        for (String key : sparseAnnotations.keys()) {
            if (sparseAnnotations.isRemoved(key)) {
                if (newMap.containsKey(key)) {
                    newMap.remove(key);
                    continue;
                }
                newMap.put(key, "~rEmOvEd~");
                continue;
            }
            String value = sparseAnnotations.value(key);
            newMap.put(key, value);
        }
    }

    @Override
    public Set<String> keys() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    @Override
    public String value(String key) {
        String value = this.map.get(key);
        return Objects.equals("~rEmOvEd~", value) ? null : value;
    }

    @Override
    public boolean isRemoved(String key) {
        return Objects.equals("~rEmOvEd~", this.map.get(key));
    }

    private static HashMap<String, String> copy(Map<String, String> original) {
        if (original instanceof HashMap) {
            return (HashMap)((HashMap)original).clone();
        }
        throw new IllegalArgumentException("Expecting HashMap instance");
    }

    public String toString() {
        return this.map == null ? "null" : this.map.toString();
    }

    public static final class Builder {
        private static final String REMOVED = "~rEmOvEd~";
        private final Map<String, String> builder = new HashMap<String, String>();

        private Builder() {
        }

        public Builder set(String key, String value) {
            this.builder.put(key, value);
            return this;
        }

        public Builder remove(String key) {
            this.builder.put(key, REMOVED);
            return this;
        }

        public DefaultAnnotations build() {
            return new DefaultAnnotations(DefaultAnnotations.copy(this.builder));
        }
    }
}

