/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.net.ElementId;

public final class HostId
extends ElementId {
    public static final HostId NONE = new HostId(MacAddress.ZERO, VlanId.NONE);
    private static final int MAC_LENGTH = 17;
    private static final int MIN_ID_LENGTH = 19;
    private final MacAddress mac;
    private final VlanId vlanId;

    private HostId(MacAddress mac, VlanId vlanId) {
        this.mac = mac;
        this.vlanId = vlanId;
    }

    private HostId() {
        this.mac = null;
        this.vlanId = null;
    }

    public MacAddress mac() {
        return this.mac;
    }

    public VlanId vlanId() {
        return this.vlanId;
    }

    public static HostId hostId(String string) {
        Preconditions.checkArgument(string.length() >= 19, "Host ID must be at least %s characters", 19);
        MacAddress mac = MacAddress.valueOf(string.substring(0, 17));
        VlanId vlanId = VlanId.vlanId(Short.parseShort(string.substring(18)));
        return new HostId(mac, vlanId);
    }

    public static HostId hostId(MacAddress mac, VlanId vlanId) {
        return new HostId(mac, vlanId);
    }

    public static HostId hostId(MacAddress mac) {
        return HostId.hostId(mac, VlanId.vlanId((short)-1));
    }

    public String toString() {
        return this.mac + "/" + this.vlanId;
    }

    public int hashCode() {
        return Objects.hash(this.mac, this.vlanId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HostId) {
            HostId other = (HostId)obj;
            return Objects.equals(this.mac, other.mac) && Objects.equals(this.vlanId, other.vlanId);
        }
        return false;
    }
}

