/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.DefaultGroupId;
import org.onosproject.core.GroupId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.flow.FlowId;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleExtPayLoad;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;

public class DefaultFlowRule
implements FlowRule {
    private final DeviceId deviceId;
    private final int priority;
    private final TrafficSelector selector;
    private final TrafficTreatment treatment;
    private final long created;
    private final FlowId id;
    private final Short appId;
    private final int timeout;
    private final boolean permanent;
    private final GroupId groupId;
    private final Integer tableId;
    private final FlowRuleExtPayLoad payLoad;

    @Deprecated
    public DefaultFlowRule(DeviceId deviceId, TrafficSelector selector, TrafficTreatment treatment, int priority, long flowId, int timeout, boolean permanent) {
        this.deviceId = deviceId;
        this.priority = priority;
        this.selector = selector;
        this.treatment = treatment;
        this.timeout = timeout;
        this.permanent = permanent;
        this.created = System.currentTimeMillis();
        this.appId = (short)(flowId >>> 48);
        this.groupId = new DefaultGroupId((short)(flowId >>> 32 & 0xFFFFL));
        this.id = FlowId.valueOf(flowId);
        this.tableId = 0;
        this.payLoad = null;
    }

    @Deprecated
    public DefaultFlowRule(DeviceId deviceId, TrafficSelector selector, TrafficTreatment treatment, int priority, long flowId, int timeout, boolean permanent, FlowRule.Type tableType) {
        this.deviceId = deviceId;
        this.priority = priority;
        this.selector = selector;
        this.treatment = treatment;
        this.timeout = timeout;
        this.permanent = permanent;
        this.created = System.currentTimeMillis();
        this.appId = (short)(flowId >>> 48);
        this.groupId = new DefaultGroupId((short)(flowId >>> 32 & 0xFFFFL));
        this.id = FlowId.valueOf(flowId);
        this.tableId = tableType.ordinal();
        this.payLoad = null;
    }

    @Deprecated
    public DefaultFlowRule(DeviceId deviceId, TrafficSelector selector, TrafficTreatment treatment, int priority, ApplicationId appId, int timeout, boolean permanent) {
        this(deviceId, selector, treatment, priority, appId, new DefaultGroupId(0), timeout, permanent);
    }

    @Deprecated
    public DefaultFlowRule(DeviceId deviceId, TrafficSelector selector, TrafficTreatment treatment, int priority, ApplicationId appId, int timeout, boolean permanent, FlowRule.Type type) {
        if (priority < 0) {
            throw new IllegalArgumentException("Priority cannot be less than 0");
        }
        this.deviceId = deviceId;
        this.priority = priority;
        this.selector = selector;
        this.treatment = treatment;
        this.appId = appId.id();
        this.groupId = new DefaultGroupId(0);
        this.timeout = timeout;
        this.permanent = permanent;
        this.created = System.currentTimeMillis();
        this.tableId = type.ordinal();
        this.payLoad = null;
        this.id = FlowId.valueOf((long)this.appId.shortValue() << 48 | (long)this.groupId.id() << 32 | (long)this.hash() & 0xFFFFFFFFL);
    }

    @Deprecated
    public DefaultFlowRule(DeviceId deviceId, TrafficSelector selector, TrafficTreatment treatment, int priority, ApplicationId appId, GroupId groupId, int timeout, boolean permanent) {
        if (priority < 0) {
            throw new IllegalArgumentException("Priority cannot be less than 0");
        }
        this.deviceId = deviceId;
        this.priority = priority;
        this.selector = selector;
        this.treatment = treatment;
        this.appId = appId.id();
        this.groupId = groupId;
        this.timeout = timeout;
        this.permanent = permanent;
        this.created = System.currentTimeMillis();
        this.tableId = 0;
        this.payLoad = null;
        this.id = FlowId.valueOf((long)this.appId.shortValue() << 48 | (long)this.groupId.id() << 32 | (long)this.hash() & 0xFFFFFFFFL);
    }

    public DefaultFlowRule(FlowRule rule) {
        this.deviceId = rule.deviceId();
        this.priority = rule.priority();
        this.selector = rule.selector();
        this.treatment = rule.treatment();
        this.appId = rule.appId();
        this.groupId = rule.groupId();
        this.id = rule.id();
        this.timeout = rule.timeout();
        this.permanent = rule.isPermanent();
        this.created = System.currentTimeMillis();
        this.tableId = rule.tableId();
        this.payLoad = rule.payLoad();
    }

    private DefaultFlowRule(DeviceId deviceId, TrafficSelector selector, TrafficTreatment treatment, Integer priority, FlowId flowId, Boolean permanent, Integer timeout, Integer tableId) {
        this.deviceId = deviceId;
        this.selector = selector;
        this.treatment = treatment;
        this.priority = priority;
        this.appId = (short)(flowId.value() >>> 48);
        this.id = flowId;
        this.permanent = permanent;
        this.timeout = timeout;
        this.tableId = tableId;
        this.created = System.currentTimeMillis();
        this.groupId = new DefaultGroupId(0);
        this.payLoad = null;
    }

    public DefaultFlowRule(DeviceId deviceId, TrafficSelector selector, TrafficTreatment treatment, int priority, ApplicationId appId, int timeout, boolean permanent, FlowRuleExtPayLoad payLoad) {
        if (priority < 0) {
            throw new IllegalArgumentException("Priority cannot be less than 0");
        }
        this.deviceId = deviceId;
        this.priority = priority;
        this.selector = selector;
        this.treatment = treatment;
        this.appId = appId.id();
        this.groupId = new DefaultGroupId(0);
        this.timeout = timeout;
        this.permanent = permanent;
        this.tableId = 0;
        this.created = System.currentTimeMillis();
        this.payLoad = payLoad;
        this.id = FlowId.valueOf((long)this.appId.shortValue() << 48 | (long)this.groupId.id() << 32 | (long)this.hash() & 0xFFFFFFFFL);
    }

    public DefaultFlowRule(DeviceId deviceId, TrafficSelector selector, TrafficTreatment treatment, int priority, ApplicationId appId, GroupId groupId, int timeout, boolean permanent, FlowRuleExtPayLoad payLoad) {
        if (priority < 0) {
            throw new IllegalArgumentException("Priority cannot be less than 0");
        }
        this.deviceId = deviceId;
        this.priority = priority;
        this.selector = selector;
        this.treatment = treatment;
        this.appId = appId.id();
        this.groupId = groupId;
        this.timeout = timeout;
        this.permanent = permanent;
        this.created = System.currentTimeMillis();
        this.tableId = 0;
        this.payLoad = payLoad;
        this.id = FlowId.valueOf((long)this.appId.shortValue() << 48 | (long)this.groupId.id() << 32 | (long)this.hash() & 0xFFFFFFFFL);
    }

    @Override
    public FlowId id() {
        return this.id;
    }

    @Override
    public short appId() {
        return this.appId;
    }

    @Override
    public GroupId groupId() {
        return this.groupId;
    }

    @Override
    public int priority() {
        return this.priority;
    }

    @Override
    public DeviceId deviceId() {
        return this.deviceId;
    }

    @Override
    public TrafficSelector selector() {
        return this.selector;
    }

    @Override
    public TrafficTreatment treatment() {
        return this.treatment;
    }

    public int hashCode() {
        return Objects.hash(this.deviceId, this.selector, this.tableId, this.payLoad);
    }

    private int hash() {
        return Objects.hash(this.deviceId, this.selector, this.tableId, this.payLoad);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultFlowRule) {
            DefaultFlowRule that = (DefaultFlowRule)obj;
            return Objects.equals(this.deviceId, that.deviceId) && Objects.equals(this.priority, that.priority) && Objects.equals(this.selector, that.selector) && Objects.equals(this.tableId, that.tableId) && Objects.equals(this.payLoad, that.payLoad);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("id", Long.toHexString(this.id.value())).add("deviceId", this.deviceId).add("priority", this.priority).add("selector", this.selector.criteria()).add("treatment", this.treatment == null ? "N/A" : this.treatment.allInstructions()).add("tableId", this.tableId).add("created", this.created).add("payLoad", this.payLoad).toString().toString();
    }

    @Override
    public int timeout() {
        return this.timeout;
    }

    @Override
    public boolean isPermanent() {
        return this.permanent;
    }

    @Override
    public int tableId() {
        return this.tableId;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public FlowRuleExtPayLoad payLoad() {
        return this.payLoad;
    }

    public static final class Builder
    implements FlowRule.Builder {
        private FlowId flowId;
        private Integer priority;
        private DeviceId deviceId;
        private Integer tableId = 0;
        private TrafficSelector selector;
        private TrafficTreatment treatment;
        private Integer timeout;
        private Boolean permanent;

        @Override
        public FlowRule.Builder withCookie(long cookie) {
            this.flowId = FlowId.valueOf(cookie);
            return this;
        }

        @Override
        public FlowRule.Builder fromApp(ApplicationId appId) {
            this.flowId = this.computeFlowId(appId);
            return this;
        }

        @Override
        public FlowRule.Builder withPriority(int priority) {
            this.priority = priority;
            return this;
        }

        @Override
        public FlowRule.Builder forDevice(DeviceId deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        @Override
        public FlowRule.Builder forTable(int tableId) {
            this.tableId = tableId;
            return this;
        }

        @Override
        public FlowRule.Builder withSelector(TrafficSelector selector) {
            this.selector = selector;
            return this;
        }

        @Override
        public FlowRule.Builder withTreatment(TrafficTreatment treatment) {
            this.treatment = treatment;
            return this;
        }

        @Override
        public FlowRule.Builder makePermanent() {
            this.timeout = 0;
            this.permanent = true;
            return this;
        }

        @Override
        public FlowRule.Builder makeTemporary(int timeout) {
            this.permanent = false;
            this.timeout = timeout;
            return this;
        }

        @Override
        public FlowRule build() {
            Preconditions.checkNotNull(this.flowId != null, "Either an application id or a cookie must be supplied");
            Preconditions.checkNotNull(this.selector != null, "Traffic selector cannot be null");
            Preconditions.checkNotNull(this.timeout != null || this.permanent != null, "Must either have a timeout or be permanent");
            Preconditions.checkNotNull(this.deviceId != null, "Must refer to a device");
            Preconditions.checkNotNull(this.priority != null, "Priority cannot be null");
            Preconditions.checkArgument(this.priority >= 0, "Priority cannot be less than 0");
            return new DefaultFlowRule(this.deviceId, this.selector, this.treatment, this.priority, this.flowId, this.permanent, this.timeout, this.tableId);
        }

        private FlowId computeFlowId(ApplicationId appId) {
            return FlowId.valueOf((long)appId.id() << 48 | (long)this.hash() & 0xFFFFFFFFL);
        }

        private int hash() {
            return Objects.hash(this.deviceId, this.selector, this.treatment, this.tableId);
        }
    }
}

