/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.onosproject.net.DeviceId;
import org.onosproject.net.flow.FlowRuleBatchEntry;
import org.onosproject.net.flow.FlowRuleBatchOperation;

public class FlowRuleBatchRequest {
    private final long batchId;
    private final Set<FlowRuleBatchEntry> ops;

    public FlowRuleBatchRequest(long batchId, Set<FlowRuleBatchEntry> ops) {
        this.batchId = batchId;
        this.ops = Collections.unmodifiableSet(ops);
    }

    public Set<FlowRuleBatchEntry> ops() {
        return this.ops;
    }

    public FlowRuleBatchOperation asBatchOperation(DeviceId deviceId) {
        ArrayList<FlowRuleBatchEntry> entries = Lists.newArrayList();
        entries.addAll(this.ops);
        return new FlowRuleBatchOperation(entries, deviceId, this.batchId);
    }

    public long batchId() {
        return this.batchId;
    }
}

