/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow.instructions;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onlab.packet.IpAddress;
import org.onosproject.net.flow.instructions.Instruction;

public abstract class L3ModificationInstruction
implements Instruction {
    public abstract L3SubType subtype();

    @Override
    public final Instruction.Type type() {
        return Instruction.Type.L3MODIFICATION;
    }

    public static final class ModTtlInstruction
    extends L3ModificationInstruction {
        private final L3SubType subtype;

        ModTtlInstruction(L3SubType subtype) {
            this.subtype = subtype;
        }

        @Override
        public L3SubType subtype() {
            return this.subtype;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.subtype().toString()).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.subtype()});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ModTtlInstruction) {
                ModTtlInstruction that = (ModTtlInstruction)obj;
                return Objects.equals((Object)this.subtype(), (Object)that.subtype());
            }
            return false;
        }
    }

    public static final class ModIPv6FlowLabelInstruction
    extends L3ModificationInstruction {
        private static final int MASK = 1048575;
        private final int flowLabel;

        ModIPv6FlowLabelInstruction(int flowLabel) {
            this.flowLabel = flowLabel & 0xFFFFF;
        }

        @Override
        public L3SubType subtype() {
            return L3SubType.IPV6_FLABEL;
        }

        public int flowLabel() {
            return this.flowLabel;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.subtype().toString()).add("flowLabel", Long.toHexString(this.flowLabel)).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.subtype(), this.flowLabel});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ModIPv6FlowLabelInstruction) {
                ModIPv6FlowLabelInstruction that = (ModIPv6FlowLabelInstruction)obj;
                return Objects.equals(this.flowLabel, that.flowLabel);
            }
            return false;
        }
    }

    public static final class ModIPInstruction
    extends L3ModificationInstruction {
        private final L3SubType subtype;
        private final IpAddress ip;

        ModIPInstruction(L3SubType subType, IpAddress addr) {
            this.subtype = subType;
            this.ip = addr;
        }

        @Override
        public L3SubType subtype() {
            return this.subtype;
        }

        public IpAddress ip() {
            return this.ip;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.subtype().toString()).add("ip", this.ip).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.subtype(), this.ip});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ModIPInstruction) {
                ModIPInstruction that = (ModIPInstruction)obj;
                return Objects.equals(this.ip, that.ip) && Objects.equals((Object)this.subtype(), (Object)that.subtype());
            }
            return false;
        }
    }

    public static enum L3SubType {
        IPV4_SRC,
        IPV4_DST,
        IPV6_SRC,
        IPV6_DST,
        IPV6_FLABEL,
        DEC_TTL,
        TTL_OUT,
        TTL_IN;

    }
}

