/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flowobjective;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveContext;

@Beta
public final class DefaultForwardingObjective
implements ForwardingObjective {
    private final TrafficSelector selector;
    private final ForwardingObjective.Flag flag;
    private final boolean permanent;
    private final int timeout;
    private final ApplicationId appId;
    private final int priority;
    private final Integer nextId;
    private final TrafficTreatment treatment;
    private final Objective.Operation op;
    private final Optional<ObjectiveContext> context;
    private final int id;

    private DefaultForwardingObjective(TrafficSelector selector, ForwardingObjective.Flag flag, boolean permanent, int timeout, ApplicationId appId, int priority, Integer nextId, TrafficTreatment treatment, Objective.Operation op) {
        this.selector = selector;
        this.flag = flag;
        this.permanent = permanent;
        this.timeout = timeout;
        this.appId = appId;
        this.priority = priority;
        this.nextId = nextId;
        this.treatment = treatment;
        this.op = op;
        this.context = Optional.empty();
        this.id = Objects.hash(new Object[]{selector, flag, permanent, timeout, appId, priority, nextId, treatment, op});
    }

    private DefaultForwardingObjective(TrafficSelector selector, ForwardingObjective.Flag flag, boolean permanent, int timeout, ApplicationId appId, int priority, Integer nextId, TrafficTreatment treatment, ObjectiveContext context, Objective.Operation op) {
        this.selector = selector;
        this.flag = flag;
        this.permanent = permanent;
        this.timeout = timeout;
        this.appId = appId;
        this.priority = priority;
        this.nextId = nextId;
        this.treatment = treatment;
        this.op = op;
        this.context = Optional.ofNullable(context);
        this.id = Objects.hash(new Object[]{selector, flag, permanent, timeout, appId, priority, nextId, treatment, op});
    }

    @Override
    public TrafficSelector selector() {
        return this.selector;
    }

    @Override
    public Integer nextId() {
        return this.nextId;
    }

    @Override
    public TrafficTreatment treatment() {
        return this.treatment;
    }

    @Override
    public ForwardingObjective.Flag flag() {
        return this.flag;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public int priority() {
        return this.priority;
    }

    @Override
    public ApplicationId appId() {
        return this.appId;
    }

    @Override
    public int timeout() {
        return this.timeout;
    }

    @Override
    public boolean permanent() {
        return this.permanent;
    }

    @Override
    public Objective.Operation op() {
        return this.op;
    }

    @Override
    public Optional<ObjectiveContext> context() {
        return this.context;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements ForwardingObjective.Builder {
        private TrafficSelector selector;
        private ForwardingObjective.Flag flag;
        private boolean permanent = true;
        private int timeout = 0;
        private int priority = 32768;
        private ApplicationId appId;
        private Integer nextId;
        private TrafficTreatment treatment;

        @Override
        public Builder withSelector(TrafficSelector selector) {
            this.selector = selector;
            return this;
        }

        @Override
        public Builder nextStep(int nextId) {
            this.nextId = nextId;
            return this;
        }

        @Override
        public Builder withTreatment(TrafficTreatment treatment) {
            this.treatment = treatment;
            return this;
        }

        @Override
        public Builder withFlag(ForwardingObjective.Flag flag) {
            this.flag = flag;
            return this;
        }

        @Override
        public Builder makeTemporary(int timeout) {
            this.timeout = timeout;
            this.permanent = false;
            return this;
        }

        @Override
        public Builder makePermanent() {
            this.permanent = true;
            return this;
        }

        @Override
        public Builder fromApp(ApplicationId appId) {
            this.appId = appId;
            return this;
        }

        @Override
        public Builder withPriority(int priority) {
            this.priority = priority;
            return this;
        }

        @Override
        public ForwardingObjective add() {
            Preconditions.checkNotNull(this.selector, "Must have a selector");
            Preconditions.checkNotNull(this.flag, "A flag must be set");
            Preconditions.checkArgument(this.nextId != null || this.treatment != null, "Must supply at least a treatment and/or a nextId");
            Preconditions.checkNotNull(this.appId, "Must supply an application id");
            return new DefaultForwardingObjective(this.selector, this.flag, this.permanent, this.timeout, this.appId, this.priority, this.nextId, this.treatment, Objective.Operation.ADD);
        }

        @Override
        public ForwardingObjective remove() {
            Preconditions.checkNotNull(this.selector, "Must have a selector");
            Preconditions.checkNotNull(this.flag, "A flag must be set");
            Preconditions.checkArgument(this.nextId != null || this.treatment != null, "Must supply at least a treatment and/or a nextId");
            Preconditions.checkNotNull(this.appId, "Must supply an application id");
            return new DefaultForwardingObjective(this.selector, this.flag, this.permanent, this.timeout, this.appId, this.priority, this.nextId, this.treatment, Objective.Operation.REMOVE);
        }

        @Override
        public ForwardingObjective add(ObjectiveContext context) {
            Preconditions.checkNotNull(this.selector, "Must have a selector");
            Preconditions.checkNotNull(this.flag, "A flag must be set");
            Preconditions.checkArgument(this.nextId != null || this.treatment != null, "Must supply at least a treatment and/or a nextId");
            Preconditions.checkNotNull(this.appId, "Must supply an application id");
            return new DefaultForwardingObjective(this.selector, this.flag, this.permanent, this.timeout, this.appId, this.priority, this.nextId, this.treatment, context, Objective.Operation.ADD);
        }

        @Override
        public ForwardingObjective remove(ObjectiveContext context) {
            Preconditions.checkNotNull(this.selector, "Must have a selector");
            Preconditions.checkNotNull(this.flag, "A flag must be set");
            Preconditions.checkArgument(this.nextId != null || this.treatment != null, "Must supply at least a treatment and/or a nextId");
            Preconditions.checkNotNull(this.appId, "Must supply an application id");
            return new DefaultForwardingObjective(this.selector, this.flag, this.permanent, this.timeout, this.appId, this.priority, this.nextId, this.treatment, context, Objective.Operation.REMOVE);
        }
    }
}

