/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.host;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.host.InterfaceIpAddress;

public final class PortAddresses {
    private final ConnectPoint connectPoint;
    private final Set<InterfaceIpAddress> ipAddresses;
    private final MacAddress macAddress;
    private final VlanId vlan;

    public PortAddresses(ConnectPoint connectPoint, Set<InterfaceIpAddress> ipAddresses, MacAddress mac, VlanId vlan) {
        this.connectPoint = connectPoint;
        this.ipAddresses = ipAddresses == null ? Collections.emptySet() : new HashSet<InterfaceIpAddress>(ipAddresses);
        this.macAddress = mac;
        this.vlan = vlan;
    }

    public ConnectPoint connectPoint() {
        return this.connectPoint;
    }

    public Set<InterfaceIpAddress> ipAddresses() {
        return this.ipAddresses;
    }

    public MacAddress mac() {
        return this.macAddress;
    }

    public VlanId vlan() {
        return this.vlan;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PortAddresses)) {
            return false;
        }
        PortAddresses otherPa = (PortAddresses)other;
        return Objects.equals(this.connectPoint, otherPa.connectPoint) && Objects.equals(this.ipAddresses, otherPa.ipAddresses) && Objects.equals(this.macAddress, otherPa.macAddress) && Objects.equals(this.vlan, otherPa.vlan);
    }

    public int hashCode() {
        return Objects.hash(this.connectPoint, this.ipAddresses, this.macAddress, this.vlan);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("connect-point", this.connectPoint).add("ip-addresses", this.ipAddresses).add("mac-address", this.macAddress).add("vlan", this.vlan).toString();
    }
}

